/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse;

public class ListTrackerConsumersIterable
implements SdkIterable<ListTrackerConsumersResponse> {
    private final LocationClient client;
    private final ListTrackerConsumersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrackerConsumersIterable(LocationClient client, ListTrackerConsumersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTrackerConsumersResponseFetcher();
    }

    public Iterator<ListTrackerConsumersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> consumerArns() {
        Function<ListTrackerConsumersResponse, Iterator> getIterator = response -> {
            if (response != null && response.consumerArns() != null) {
                return response.consumerArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrackerConsumersResponseFetcher
    implements SyncPageFetcher<ListTrackerConsumersResponse> {
        private ListTrackerConsumersResponseFetcher() {
        }

        public boolean hasNextPage(ListTrackerConsumersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrackerConsumersResponse nextPage(ListTrackerConsumersResponse previousPage) {
            if (previousPage == null) {
                return ListTrackerConsumersIterable.this.client.listTrackerConsumers(ListTrackerConsumersIterable.this.firstRequest);
            }
            return ListTrackerConsumersIterable.this.client.listTrackerConsumers((ListTrackerConsumersRequest)((Object)ListTrackerConsumersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

