/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.PermissionArnListCopier;
import software.amazon.awssdk.services.ram.model.PrincipalArnOrIdListCopier;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceArnListCopier;
import software.amazon.awssdk.services.ram.model.Tag;
import software.amazon.awssdk.services.ram.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceShareRequest
extends RamRequest
implements ToCopyableBuilder<Builder, CreateResourceShareRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateResourceShareRequest.getter(CreateResourceShareRequest::name)).setter(CreateResourceShareRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceArns").getter(CreateResourceShareRequest.getter(CreateResourceShareRequest::resourceArns)).setter(CreateResourceShareRequest.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("principals").getter(CreateResourceShareRequest.getter(CreateResourceShareRequest::principals)).setter(CreateResourceShareRequest.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateResourceShareRequest.getter(CreateResourceShareRequest::tags)).setter(CreateResourceShareRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALLOW_EXTERNAL_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowExternalPrincipals").getter(CreateResourceShareRequest.getter(CreateResourceShareRequest::allowExternalPrincipals)).setter(CreateResourceShareRequest.setter(Builder::allowExternalPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowExternalPrincipals").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateResourceShareRequest.getter(CreateResourceShareRequest::clientToken)).setter(CreateResourceShareRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<List<String>> PERMISSION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permissionArns").getter(CreateResourceShareRequest.getter(CreateResourceShareRequest::permissionArns)).setter(CreateResourceShareRequest.setter(Builder::permissionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RESOURCE_ARNS_FIELD, PRINCIPALS_FIELD, TAGS_FIELD, ALLOW_EXTERNAL_PRINCIPALS_FIELD, CLIENT_TOKEN_FIELD, PERMISSION_ARNS_FIELD));
    private final String name;
    private final List<String> resourceArns;
    private final List<String> principals;
    private final List<Tag> tags;
    private final Boolean allowExternalPrincipals;
    private final String clientToken;
    private final List<String> permissionArns;

    private CreateResourceShareRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.resourceArns = builder.resourceArns;
        this.principals = builder.principals;
        this.tags = builder.tags;
        this.allowExternalPrincipals = builder.allowExternalPrincipals;
        this.clientToken = builder.clientToken;
        this.permissionArns = builder.permissionArns;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public final boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public final List<String> principals() {
        return this.principals;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean allowExternalPrincipals() {
        return this.allowExternalPrincipals;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasPermissionArns() {
        return this.permissionArns != null && !(this.permissionArns instanceof SdkAutoConstructList);
    }

    public final List<String> permissionArns() {
        return this.permissionArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowExternalPrincipals());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissionArns() ? this.permissionArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceShareRequest)) {
            return false;
        }
        CreateResourceShareRequest other = (CreateResourceShareRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.allowExternalPrincipals(), other.allowExternalPrincipals()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasPermissionArns() == other.hasPermissionArns() && Objects.equals(this.permissionArns(), other.permissionArns());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourceShareRequest").add("Name", (Object)this.name()).add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("Principals", this.hasPrincipals() ? this.principals() : null).add("Tags", this.hasTags() ? this.tags() : null).add("AllowExternalPrincipals", (Object)this.allowExternalPrincipals()).add("ClientToken", (Object)this.clientToken()).add("PermissionArns", this.hasPermissionArns() ? this.permissionArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "allowExternalPrincipals": {
                return Optional.ofNullable(clazz.cast(this.allowExternalPrincipals()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "permissionArns": {
                return Optional.ofNullable(clazz.cast(this.permissionArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceShareRequest, T> g) {
        return obj -> g.apply((CreateResourceShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> principals = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean allowExternalPrincipals;
        private String clientToken;
        private List<String> permissionArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceShareRequest model) {
            super(model);
            this.name(model.name);
            this.resourceArns(model.resourceArns);
            this.principals(model.principals);
            this.tags(model.tags);
            this.allowExternalPrincipals(model.allowExternalPrincipals);
            this.clientToken(model.clientToken);
            this.permissionArns(model.permissionArns);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Collection<String> getPrincipals() {
            if (this.principals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.principals;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAllowExternalPrincipals() {
            return this.allowExternalPrincipals;
        }

        public final void setAllowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
        }

        @Override
        public final Builder allowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Collection<String> getPermissionArns() {
            if (this.permissionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissionArns;
        }

        public final void setPermissionArns(Collection<String> permissionArns) {
            this.permissionArns = PermissionArnListCopier.copy(permissionArns);
        }

        @Override
        public final Builder permissionArns(Collection<String> permissionArns) {
            this.permissionArns = PermissionArnListCopier.copy(permissionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionArns(String ... permissionArns) {
            this.permissionArns(Arrays.asList(permissionArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceShareRequest build() {
            return new CreateResourceShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceShareRequest> {
        public Builder name(String var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder principals(Collection<String> var1);

        public Builder principals(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder allowExternalPrincipals(Boolean var1);

        public Builder clientToken(String var1);

        public Builder permissionArns(Collection<String> var1);

        public Builder permissionArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

