/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse;

public class ListPermissionVersionsIterable
implements SdkIterable<ListPermissionVersionsResponse> {
    private final RamClient client;
    private final ListPermissionVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPermissionVersionsIterable(RamClient client, ListPermissionVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPermissionVersionsResponseFetcher();
    }

    public Iterator<ListPermissionVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPermissionVersionsResponseFetcher
    implements SyncPageFetcher<ListPermissionVersionsResponse> {
        private ListPermissionVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPermissionVersionsResponse nextPage(ListPermissionVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionVersionsIterable.this.client.listPermissionVersions(ListPermissionVersionsIterable.this.firstRequest);
            }
            return ListPermissionVersionsIterable.this.client.listPermissionVersions((ListPermissionVersionsRequest)((Object)ListPermissionVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

