/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.ListResourceTypesRequest;
import software.amazon.awssdk.services.ram.model.ListResourceTypesResponse;

public class ListResourceTypesIterable
implements SdkIterable<ListResourceTypesResponse> {
    private final RamClient client;
    private final ListResourceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceTypesIterable(RamClient client, ListResourceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourceTypesResponseFetcher();
    }

    public Iterator<ListResourceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListResourceTypesResponseFetcher
    implements SyncPageFetcher<ListResourceTypesResponse> {
        private ListResourceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceTypesResponse nextPage(ListResourceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceTypesIterable.this.client.listResourceTypes(ListResourceTypesIterable.this.firstRequest);
            }
            return ListResourceTypesIterable.this.client.listResourceTypes((ListResourceTypesRequest)((Object)ListResourceTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

