/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckSummary;

public class GetCellReadinessSummaryIterable
implements SdkIterable<GetCellReadinessSummaryResponse> {
    private final Route53RecoveryReadinessClient client;
    private final GetCellReadinessSummaryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCellReadinessSummaryIterable(Route53RecoveryReadinessClient client, GetCellReadinessSummaryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCellReadinessSummaryResponseFetcher();
    }

    public Iterator<GetCellReadinessSummaryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReadinessCheckSummary> readinessChecks() {
        Function<GetCellReadinessSummaryResponse, Iterator> getIterator = response -> {
            if (response != null && response.readinessChecks() != null) {
                return response.readinessChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCellReadinessSummaryResponseFetcher
    implements SyncPageFetcher<GetCellReadinessSummaryResponse> {
        private GetCellReadinessSummaryResponseFetcher() {
        }

        public boolean hasNextPage(GetCellReadinessSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCellReadinessSummaryResponse nextPage(GetCellReadinessSummaryResponse previousPage) {
            if (previousPage == null) {
                return GetCellReadinessSummaryIterable.this.client.getCellReadinessSummary(GetCellReadinessSummaryIterable.this.firstRequest);
            }
            return GetCellReadinessSummaryIterable.this.client.getCellReadinessSummary((GetCellReadinessSummaryRequest)((Object)GetCellReadinessSummaryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

