/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessAsyncClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckSummary;

public class GetCellReadinessSummaryPublisher
implements SdkPublisher<GetCellReadinessSummaryResponse> {
    private final Route53RecoveryReadinessAsyncClient client;
    private final GetCellReadinessSummaryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCellReadinessSummaryPublisher(Route53RecoveryReadinessAsyncClient client, GetCellReadinessSummaryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCellReadinessSummaryPublisher(Route53RecoveryReadinessAsyncClient client, GetCellReadinessSummaryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCellReadinessSummaryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCellReadinessSummaryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReadinessCheckSummary> readinessChecks() {
        Function<GetCellReadinessSummaryResponse, Iterator> getIterator = response -> {
            if (response != null && response.readinessChecks() != null) {
                return response.readinessChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetCellReadinessSummaryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetCellReadinessSummaryResponseFetcher
    implements AsyncPageFetcher<GetCellReadinessSummaryResponse> {
        private GetCellReadinessSummaryResponseFetcher() {
        }

        public boolean hasNextPage(GetCellReadinessSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCellReadinessSummaryResponse> nextPage(GetCellReadinessSummaryResponse previousPage) {
            if (previousPage == null) {
                return GetCellReadinessSummaryPublisher.this.client.getCellReadinessSummary(GetCellReadinessSummaryPublisher.this.firstRequest);
            }
            return GetCellReadinessSummaryPublisher.this.client.getCellReadinessSummary((GetCellReadinessSummaryRequest)((Object)GetCellReadinessSummaryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

