/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CLMLanguageCode {
    EN_US("en-US"),
    HI_IN("hi-IN"),
    ES_US("es-US"),
    EN_GB("en-GB"),
    EN_AU("en-AU"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CLMLanguageCode> VALUE_MAP;
    private final String value;

    private CLMLanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CLMLanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CLMLanguageCode> knownValues() {
        EnumSet<CLMLanguageCode> knownValues = EnumSet.allOf(CLMLanguageCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CLMLanguageCode.class, CLMLanguageCode::toString);
    }
}

