/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JavaClass
extends AbstractJavaEntity
implements JavaClassParent {
    private List methods = new LinkedList();
    private JavaMethod[] methodsArray;
    private List fields = new LinkedList();
    private JavaField[] fieldsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private boolean interfce;
    private Type type;
    private Type superClass;
    private Type[] implementz = new Type[0];
    private JavaClassParent parent;
    public static final Type OBJECT = new Type("java.lang.Object", 0);
    private JavaClassCache javaClassCache;

    public void setJavaClassCache(JavaClassCache javaClassCache) {
        this.javaClassCache = javaClassCache;
    }

    public boolean isInterface() {
        return this.interfce;
    }

    public Type getSuperClass() {
        if (!this.interfce && this.superClass == null) {
            return OBJECT;
        }
        return this.superClass;
    }

    public JavaClass getSuperJavaClass() {
        if (this.javaClassCache == null) {
            throw new UnsupportedOperationException("JavaClassCache unavailable for this JavaClass");
        }
        return this.javaClassCache.getClassByName(this.getSuperClass().getValue());
    }

    public Type[] getImplements() {
        return this.implementz;
    }

    protected void writeBody(IndentBuffer indentBuffer) {
        Object object;
        this.writeAccessibilityModifier(indentBuffer);
        this.writeNonAccessibilityModifiers(indentBuffer);
        indentBuffer.write(this.interfce ? "interface " : "class ");
        indentBuffer.write(this.name);
        if (this.superClass != null) {
            indentBuffer.write(" extends ");
            indentBuffer.write(this.superClass.getValue());
        }
        if (this.implementz.length > 0) {
            indentBuffer.write(this.interfce ? " extends " : " implements ");
            int n = 0;
            while (n < this.implementz.length) {
                if (n > 0) {
                    indentBuffer.write(", ");
                }
                indentBuffer.write(this.implementz[n].getValue());
                ++n;
            }
        }
        indentBuffer.write(" {");
        indentBuffer.newline();
        indentBuffer.indent();
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            object = (JavaField)iterator.next();
            indentBuffer.newline();
            ((AbstractJavaEntity)object).write(indentBuffer);
        }
        object = this.methods.iterator();
        while (object.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)object.next();
            indentBuffer.newline();
            javaMethod.write(indentBuffer);
        }
        indentBuffer.deindent();
        indentBuffer.newline();
        indentBuffer.write('}');
        indentBuffer.newline();
    }

    public void setInterface(boolean bl) {
        this.interfce = bl;
    }

    public void addMethod(JavaMethod javaMethod) {
        this.methods.add(javaMethod);
        javaMethod.setParentClass(this);
        this.methodsArray = null;
    }

    public void setSuperClass(Type type) {
        this.superClass = type;
    }

    public void setImplementz(Type[] typeArray) {
        this.implementz = typeArray;
    }

    public void addField(JavaField javaField) {
        this.fields.add(javaField);
        javaField.setParentClass(this);
        this.fieldsArray = null;
    }

    public void setParent(JavaClassParent javaClassParent) {
        this.parent = javaClassParent;
    }

    public JavaClassParent getParent() {
        return this.parent;
    }

    public JavaSource getParentSource() {
        JavaClassParent javaClassParent = this.getParent();
        return javaClassParent == null ? null : javaClassParent.getParentSource();
    }

    public String getPackage() {
        return this.getParentSource().getPackage();
    }

    public String getFullyQualifiedName() {
        return this.getParent().asClassNamespace() + "." + this.getName();
    }

    public String asClassNamespace() {
        return this.getFullyQualifiedName();
    }

    public Type asType() {
        if (this.type == null) {
            this.type = new Type(this.getFullyQualifiedName(), 0);
        }
        return this.type;
    }

    public JavaMethod[] getMethods() {
        if (this.methodsArray == null) {
            this.methodsArray = new JavaMethod[this.methods.size()];
            this.methods.toArray(this.methodsArray);
        }
        return this.methodsArray;
    }

    public JavaField[] getFields() {
        if (this.fieldsArray == null) {
            this.fieldsArray = new JavaField[this.fields.size()];
            this.fields.toArray(this.fieldsArray);
        }
        return this.fieldsArray;
    }

    public void addClass(JavaClass javaClass) {
        this.classes.add(javaClass);
        javaClass.setParent(this);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }
}

