/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.plugin.automodel;

import com.eova.common.plugin.automodel.TableBind;
import com.eova.common.utils.io.ClassUtil;
import com.eova.common.utils.xx;
import com.jfinal.kit.LogKit;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.Model;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class AutoBindModel {
    private final URL classUrl = this.getClass().getResource("/");
    private final String lib = new File(this.classUrl.getFile()).getParent() + "\\lib\\";
    private static List<String> includeJars = new ArrayList<String>();
    private static List<Class<? extends Model>> excludeClasses = new ArrayList<Class<? extends Model>>();
    private ActiveRecordPlugin arp;

    public AutoBindModel(ActiveRecordPlugin arp) {
        this.arp = arp;
    }

    public void addExcludeClass(Class<? extends Model> cs) {
        if (cs != null) {
            excludeClasses.add(cs);
        }
    }

    public <T> List<Class<? extends T>> findInClasspathAndJars(Class<T> clazz) {
        List<Object> classFileList = new ArrayList();
        String classUrlPath = new File(this.classUrl.getFile()).getAbsolutePath();
        String libPath = new File(this.lib).getAbsolutePath();
        System.out.println(classUrlPath);
        System.out.println(libPath);
        classFileList = ClassUtil.findFiles(classUrlPath, "*.class");
        classFileList.addAll(ClassUtil.findjarFiles(libPath, includeJars));
        return ClassUtil.extraction(clazz, classFileList);
    }

    public void loadModel() {
        LogKit.info((String)("AutoBindModel.loadModel():classes url:" + this.classUrl));
        LogKit.info((String)("AutoBindModel.loadModel():lib url:" + this.lib));
        List<Class<Model>> modelClasses = this.findInClasspathAndJars(Model.class);
        for (Class<Model> modelClass : modelClasses) {
            if (excludeClasses.contains(modelClass)) continue;
            String tableName = modelClass.getSimpleName().toLowerCase();
            TableBind tb = modelClass.getAnnotation(TableBind.class);
            if (tb != null) {
                if (!xx.isEmpty(tb.tableName())) {
                    tableName = tb.tableName().toLowerCase();
                }
                if (!xx.isEmpty(tb.pkName())) {
                    this.arp.addMapping(tableName, tb.pkName(), modelClass);
                    LogKit.debug((String)("addMapping(" + tableName + ", " + tb.pkName() + "," + modelClass.getName() + ")"));
                    continue;
                }
            }
            this.arp.addMapping(tableName, modelClass);
            LogKit.debug((String)("addMapping(" + tableName + ", " + modelClass.getName() + ")"));
        }
    }

    public AutoBindModel addJar(String jarName) {
        if (!xx.isEmpty(jarName)) {
            includeJars.add(jarName);
        }
        return this;
    }
}

