/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.plugin.quartz;

import com.eova.model.Task;
import com.jfinal.kit.LogKit;
import com.jfinal.plugin.IPlugin;
import java.util.List;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzPlugin
implements IPlugin {
    private SchedulerFactory sf = null;
    public static Scheduler scheduler = null;

    public boolean start() {
        this.sf = new StdSchedulerFactory();
        try {
            scheduler = this.sf.getScheduler();
            List<Task> tasks = Task.dao.findAll();
            for (Task task : tasks) {
                Class<?> clazz;
                String jobClassName = task.getStr("clazz");
                String jobCronExp = task.getStr("exp");
                int state = task.getInt("state");
                try {
                    clazz = Class.forName(jobClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                JobDetail job = JobBuilder.newJob(clazz).withIdentity(jobClassName, jobClassName).build();
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobClassName, jobClassName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobCronExp)).build();
                try {
                    scheduler.scheduleJob(job, (Trigger)trigger);
                    if (state == 0) {
                        scheduler.pauseTrigger(trigger.getKey());
                    }
                }
                catch (SchedulerException e) {
                    new RuntimeException(e);
                }
                LogKit.info((String)(job.getKey() + " loading and exp: " + trigger.getCronExpression()));
            }
            scheduler.start();
        }
        catch (SchedulerException e) {
            new RuntimeException(e);
        }
        return true;
    }

    public boolean stop() {
        try {
            scheduler.shutdown();
        }
        catch (SchedulerException e) {
            LogKit.error((String)"shutdown error", (Throwable)e);
            return false;
        }
        return true;
    }
}

