/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.render;

import com.jfinal.render.Render;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;

public class Html2DocRender
extends Render {
    private static final String CONTENT_TYPE = "application/msword;charset=" + Html2DocRender.getEncoding();
    private final String file;
    private final String fileName;

    public Html2DocRender(String fileName, String path, HashMap<String, Object> paras) {
        this.fileName = fileName;
        this.file = this.parseFile(path, paras);
    }

    public void render() {
        try (PrintWriter writer = null;){
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(this.fileName, "UTF-8"));
            this.response.setDateHeader("Expires", 0L);
            this.response.setContentType(CONTENT_TYPE);
            this.response.setCharacterEncoding(Html2DocRender.getEncoding());
            writer = this.response.getWriter();
            writer.write(this.file);
            writer.flush();
        }
    }

    public String parseFile(String path, HashMap<String, Object> params) {
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader("doc");
        Configuration cfg = null;
        try {
            cfg = Configuration.defaultConfiguration();
            cfg.setPlaceholderStart("[");
            cfg.setPlaceholderEnd("]");
            cfg.setCharset("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GroupTemplate gt = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
        Template t = gt.getTemplate(File.separator + path);
        for (String key : params.keySet()) {
            Object o = params.get(key);
            t.binding(key, o);
        }
        return t.render();
    }
}

