/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.render;

import com.eova.common.utils.io.TxtUtil;
import com.eova.engine.DynamicParse;
import com.jfinal.render.Render;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import org.beetl.core.Template;

public class Html2PdfRender
extends Render {
    private static final String CONTENT_TYPE = "application/pdf;charset=" + Html2PdfRender.getEncoding();
    private final String file;
    private final String fileName;

    public Html2PdfRender(String fileName, String path, HashMap<String, Object> paras) {
        this.fileName = fileName;
        this.file = this.parse(path, paras);
    }

    public void render() {
        try (PrintWriter writer = null;){
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(this.fileName, "UTF-8"));
            this.response.setDateHeader("Expires", 0L);
            this.response.setContentType(CONTENT_TYPE);
            this.response.setCharacterEncoding(Html2PdfRender.getEncoding());
            writer = this.response.getWriter();
            writer.write(this.file);
            writer.flush();
        }
    }

    public String parse(String path, HashMap<String, Object> params) {
        String temp = TxtUtil.getTxt(path);
        Template t = DynamicParse.gt.getTemplate(temp);
        for (String key : params.keySet()) {
            Object o = params.get(key);
            t.binding(key, o);
        }
        return t.render();
    }
}

