/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.render;

import com.eova.common.utils.io.TxtUtil;
import com.eova.engine.DynamicParse;
import com.jfinal.render.Render;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import org.beetl.core.Template;

public class Html2XlsRender
extends Render {
    private static final String CONTENT_TYPE = "application/msexcel;charset=" + Html2XlsRender.getEncoding();
    private final String xls;
    private final String fileName;

    public Html2XlsRender(String fileName, String path, HashMap<String, Object> paras) {
        this.fileName = fileName;
        this.xls = this.parseXls(path, paras);
    }

    public void render() {
        try (PrintWriter writer = null;){
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(this.fileName, "UTF-8"));
            this.response.setDateHeader("Expires", 0L);
            this.response.setContentType(CONTENT_TYPE);
            this.response.setCharacterEncoding(Html2XlsRender.getEncoding());
            writer = this.response.getWriter();
            writer.write(this.xls);
            writer.flush();
        }
    }

    public String parseXls(String path, HashMap<String, Object> params) {
        String temp = TxtUtil.getTxt(path);
        Template t = DynamicParse.gt.getTemplate(temp);
        for (String key : params.keySet()) {
            Object o = params.get(key);
            t.binding(key, o);
        }
        return t.render();
    }
}

