/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.render;

import com.eova.common.render.RenderUtil;
import com.jfinal.render.Render;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.HashMap;

public class OfficeRender
extends Render {
    private static final String CONTENT_TYPE_EXCEL = "application/msexcel;charset=" + OfficeRender.getEncoding();
    private static final String CONTENT_TYPE_WROD = "application/msword;charset=" + OfficeRender.getEncoding();
    private static final String CONTENT_TYPE_PDF = "application/pdf;charset=" + OfficeRender.getEncoding();
    private static final String FILE_TYPE_XLS = "xls";
    private static final String FILE_TYPE_DOC = "doc";
    private static final String FILE_TYPE_PDF = "pdf";
    private final String file;
    private final String fileType;
    private final String fileName;

    public OfficeRender(String fileType, String fileName, String path, HashMap<String, Object> paras) {
        this.fileType = fileType;
        this.fileName = fileName;
        this.file = RenderUtil.renderFile(path, paras);
    }

    public void render() {
        try (PrintWriter writer = null;){
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(this.fileName, OfficeRender.getEncoding()));
            this.response.setDateHeader("Expires", 0L);
            if (this.fileType.equalsIgnoreCase(FILE_TYPE_XLS)) {
                this.response.setContentType(CONTENT_TYPE_EXCEL);
            } else if (this.fileType.equalsIgnoreCase(FILE_TYPE_DOC)) {
                this.response.setContentType(CONTENT_TYPE_WROD);
            } else if (this.fileType.equalsIgnoreCase(FILE_TYPE_PDF)) {
                this.response.setContentType(CONTENT_TYPE_PDF);
            }
            this.response.setCharacterEncoding(OfficeRender.getEncoding());
            writer = this.response.getWriter();
            writer.write(this.file);
            writer.flush();
        }
    }
}

