/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.render;

import com.eova.common.utils.excel.ExcelUtil;
import com.eova.model.MetaField;
import com.eova.model.MetaObject;
import com.jfinal.kit.LogKit;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletOutputStream;

public class XlsRender
extends Render {
    private static final String CONTENT_TYPE = "application/msexcel;charset=" + XlsRender.getEncoding();
    private final MetaObject object;
    private final List<MetaField> items;
    private final List<Record> data;
    private final String fileName;

    public XlsRender(List<Record> data, List<MetaField> items, MetaObject object) {
        this.data = data;
        this.items = items;
        this.object = object;
        this.fileName = object.getStr("name") + ".xls";
    }

    public void render() {
        this.response.reset();
        try {
            this.response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(this.fileName, XlsRender.getEncoding()));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        this.response.setContentType(CONTENT_TYPE);
        ServletOutputStream os = null;
        try {
            os = this.response.getOutputStream();
            ExcelUtil.createExcel((OutputStream)os, this.data, this.items, this.object);
        }
        catch (Exception e) {
            throw new RenderException((Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            catch (IOException e) {
                LogKit.error((String)e.getMessage(), (Throwable)e);
            }
        }
    }
}

