/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.render;

import com.jfinal.render.Render;
import java.io.PrintWriter;

public class XmlRender
extends Render {
    private static final String contentType = "text/xml;charset=" + XmlRender.getEncoding();
    private String xml;

    public XmlRender(String xml) {
        if (xml == null) {
            throw new IllegalArgumentException("The parameter xml can not be null.");
        }
        this.xml = xml;
    }

    public void render() {
        try (PrintWriter writer = null;){
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setDateHeader("Expires", 0L);
            this.response.setContentType(contentType);
            this.response.setCharacterEncoding(XmlRender.getEncoding());
            writer = this.response.getWriter();
            writer.write(this.xml);
            writer.flush();
        }
    }
}

