/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.utils.db;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eova.common.utils.db.DsUtil;
import com.eova.common.utils.io.TxtUtil;
import com.eova.common.utils.xx;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DbUtil {
    private static String convertDataType(String typeName) {
        if (typeName.contains("INT")) {
            return "NUMBER";
        }
        if (typeName.contains("BIT")) {
            return "CHAR";
        }
        if (typeName.indexOf("TIME") != -1 || typeName.indexOf("DATE") != -1) {
            return "DATE";
        }
        return "VARCHAR2";
    }

    public static void createOracleSql(String ds, String tableNamePattern) {
        StringBuilder sbs = new StringBuilder();
        StringBuilder sbDrop = new StringBuilder();
        StringBuilder sbDropSeq = new StringBuilder();
        StringBuilder sbCreateSeq = new StringBuilder();
        List<String> tables = DsUtil.getTableNamesByConfigName(ds, "Table", null, tableNamePattern);
        for (String table : tables) {
            String pk = DsUtil.getPkName(ds, table);
            String drop = "drop table " + table + ";\n";
            sbDrop.append(drop);
            String dropSeq = "drop sequence seq_" + table + ";\n";
            sbDropSeq.append(dropSeq);
            String sql = "select max(" + pk + ") from " + table;
            Object max = Db.use((String)ds).queryColumn(sql);
            if (xx.isEmpty(max)) {
                max = 0;
            }
            String createSeq = "create sequence seq_" + table + " increment by 1 start with " + max + 1 + " maxvalue 9999999999;\n";
            sbCreateSeq.append(createSeq);
            JSONArray list = DsUtil.getColumnInfoByConfigName(ds, table);
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            StringBuilder sb3 = new StringBuilder();
            sb.append("create table " + table);
            sb.append("(\n");
            for (int i = 0; i < list.size(); ++i) {
                String str;
                JSONObject o = list.getJSONObject(i);
                Record re = new Record();
                re.set("en", (Object)o.getString("COLUMN_NAME"));
                re.set("cn", (Object)o.getString("REMARKS"));
                re.set("order_num", (Object)o.getIntValue("ORDINAL_POSITION"));
                re.set("is_required", (Object)(!"YES".equalsIgnoreCase(o.getString("IS_NULLABLE")) ? 1 : 0));
                boolean isAuto = "YES".equalsIgnoreCase(o.getString("IS_AUTOINCREMENT"));
                re.set("is_auto", (Object)isAuto);
                String typeName = o.getString("TYPE_NAME");
                re.set("data_type", (Object)DbUtil.convertDataType(typeName));
                int size = o.getIntValue("COLUMN_SIZE");
                if (size == 0) {
                    size = 1;
                } else if (size > 4000) {
                    size = 4000;
                }
                String def = o.getString("COLUMN_DEF");
                re.set("defaulter", (Object)def);
                String dataType = re.getStr("data_type");
                sb.append("    " + re.getStr("en") + " " + dataType + (dataType.equals("DATE") ? "" : "(" + size + ")"));
                if (re.getBoolean("is_required").booleanValue()) {
                    sb.append(" NOT NULL");
                }
                sb.append(",\n");
                String remarks = o.getString("REMARKS");
                if (!xx.isEmpty(remarks)) {
                    str = "comment on column %s.%s is '%s';\n";
                    sb2.append(String.format(str, table, re.getStr("en"), remarks));
                }
                if (xx.isEmpty(def)) continue;
                str = "alter table %s modify %s default %s;\n";
                if (def.equals("CURRENT_TIMESTAMP")) {
                    sb3.append(String.format(str, table, re.getStr("en"), "sysdate"));
                    continue;
                }
                sb3.append(String.format(str, table, re.getStr("en"), xx.format(def)));
            }
            sb.delete(sb.length() - 2, sb.length() - 1);
            sb.append(");\n");
            String pkName = DsUtil.getPkName(ds, table);
            if (!xx.isEmpty(pkName)) {
                String str = "\nalter table %s add constraint pk_%s primary key(%s);\n";
                sb2.insert(0, String.format(str, table, table, pkName));
            }
            sbs.append((CharSequence)sb);
            sbs.append((CharSequence)sb2);
            sbs.append((CharSequence)sb3);
            sbs.append("\n");
        }
        System.out.println(sbDrop.toString());
        System.out.println(sbDropSeq.toString());
        System.out.println(sbCreateSeq.toString());
        System.out.println(sbs.toString());
    }

    public static Object convertOracleValue(Object value, int type) {
        String s = value.toString();
        if (type == 2) {
            if (s.contains(".")) {
                return Double.valueOf(s);
            }
            if (s.length() > 11) {
                return Long.valueOf(s);
            }
            if (s.length() <= 11) {
                return Integer.valueOf(s);
            }
        }
        if (type == 1 && s.length() == 1) {
            if (s.equals("1")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return value;
    }

    public static String buildDateValue(Object value) {
        return "to_date('" + value + "','yyyy-mm-dd HH24:MI:SS')";
    }

    public static void generateSql(List<Record> list, String table, String auto, StringBuilder sb) {
        HashSet<String> updatePid = new HashSet<String>();
        for (Record r : list) {
            Integer pid;
            DbUtil.appendSql(table, auto, sb, r);
            if (!table.equals("eova_menu") || (pid = r.getInt("parent_id")) == 0) continue;
            String findPCode = "select code from eova_menu where id = ?";
            String pcode = Db.use((String)"eova").queryStr(findPCode, new Object[]{pid});
            String sql = String.format("UPDATE eova_menu SET parent_id = ( SELECT id FROM ( SELECT id FROM eova_menu WHERE CODE = '%s' ) m ) WHERE CODE = '%s'", pcode, r.getStr("code"));
            updatePid.add(sql);
        }
        sb.append("\n");
        for (String s : updatePid) {
            sb.append(s);
            sb.append(";\n");
        }
    }

    private static void appendSql(String table, String auto, StringBuilder sb, Record r) {
        String[] names;
        sb.append("INSERT INTO " + table + " (");
        for (String n : names = r.getColumnNames()) {
            if (n.equals(auto)) continue;
            sb.append(DbUtil.format(n));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")  VALUES (");
        for (String n : names) {
            if (n.equals(auto)) continue;
            sb.append(DbUtil.formatVal(r.get(n)));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(");");
        sb.append("\n");
    }

    public static String format(String name) {
        return '`' + name + '`';
    }

    private static Object formatVal(Object o) {
        if (o == null) {
            return o;
        }
        String s = o.toString();
        if (s.equals("true")) {
            return 1;
        }
        if (s.equals("false")) {
            return 0;
        }
        if (s.indexOf("\\") != -1) {
            s = s.replaceAll("\\\\", "\\\\\\\\");
        }
        if (s.indexOf("'") != -1) {
            s = s.replaceAll("'", "\\\\'");
        }
        return xx.format(s);
    }

    public static String formatSql(String sql) {
        sql = sql.trim();
        if ((sql = sql.replaceAll("\\s+", " ")).endsWith(" where 1=1")) {
            sql = sql.replace(" where 1=1", "");
        }
        sql = sql.replace(" where 1=1 and ", " where ");
        sql = sql.replace(" where 1=1 order ", " order ");
        return sql;
    }

    public static boolean compareTable(String full, String tableName) {
        if ((full = full.replace("`", "").replace(" ", "").toLowerCase()).equals(tableName = tableName.replace("`", "").replace(" ", "").toLowerCase())) {
            return true;
        }
        String[] ss = full.split("\\.");
        if (ss.length == 2) {
            return ss[0].equals(tableName);
        }
        if (ss.length == 3) {
            return (ss[0] + "." + ss[1]).equals(tableName);
        }
        return false;
    }

    public static boolean compareField(String full, String fieldName) {
        if ((full = full.replace("`", "").replace(" ", "").toLowerCase()).equals(fieldName = fieldName.replace("`", "").replace(" ", "").toLowerCase())) {
            return true;
        }
        String[] ss = full.split("\\.");
        if (ss.length == 2) {
            return ss[1].equals(fieldName);
        }
        if (ss.length == 3) {
            return (ss[1] + "." + ss[2]).equals(fieldName) || ss[2].equals(fieldName);
        }
        return false;
    }

    public static void main(String[] args) {
        boolean s = DbUtil.compareTable("`demo`.`hotel`.`id`", "demo.hotel");
        System.out.println(s);
    }

    public static String getEndName(String full) {
        if ((full = full.replace("`", "").replace(" ", "")).contains(".")) {
            String[] ss = full.split("\\.");
            return ss[ss.length - 1];
        }
        return full;
    }

    public static String simplify(String full) {
        full = full.replace("`", "").replace(" ", "");
        return null;
    }

    public static List<String> loadSql(String sqlFilePath) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        try {
            String txt = TxtUtil.getTxt(sqlFilePath);
            String[] sqlArr = txt.split(";");
            for (int i = 0; i < sqlArr.length; ++i) {
                String sql = sqlArr[i].replaceAll("--.*", "").trim();
                if (sql.equals("")) continue;
                sqlList.add(sql);
            }
            return sqlList;
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }
}

