/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.utils.db;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eova.common.utils.xx;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.Record;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DsUtil {
    public static final String TABLE = "Table";
    public static final String VIEW = "View";

    public static DatabaseMetaData getDatabaseMetaData(String ds, Properties props) {
        DatabaseMetaData databaseMetaData;
        Connection conn = null;
        try {
            DatabaseMetaData md;
            Config config = DbKit.getConfig((String)ds);
            if (config == null) {
                throw new SQLException(ds + " datasrouce can not get config");
            }
            conn = config.getDataSource().getConnection();
            if (props != null) {
                conn.setClientInfo(props);
            }
            databaseMetaData = md = conn.getMetaData();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DsUtil.closeConn(conn);
                throw throwable;
            }
        }
        DsUtil.closeConn(conn);
        return databaseMetaData;
    }

    public static DatabaseMetaData getDatabaseMetaData(String ds) {
        return DsUtil.getDatabaseMetaData(ds, null);
    }

    public static String getDbNameByConfigName(String ds) {
        try {
            Config config = DbKit.getConfig((String)ds);
            if (config == null) {
                throw new SQLException(ds + " datasrouce can not get config");
            }
            Connection conn = config.getDataSource().getConnection();
            if (conn == null) {
                return null;
            }
            return conn.getCatalog();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getUserNameByConfigName(String ds) {
        try {
            DatabaseMetaData databaseMetaData = DsUtil.getDatabaseMetaData(ds);
            return databaseMetaData.getUserName();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getTableNamesByConfigName(String ds, String type, String schemaPattern, String tableNamePattern) {
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        ArrayList<String> tables = new ArrayList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData md = DsUtil.getDatabaseMetaData(ds);
            rs = md.getTables(null, schemaPattern, tableNamePattern, new String[]{type.toUpperCase()});
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME"));
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DsUtil.closeResultSet(rs);
                throw throwable;
            }
        }
        DsUtil.closeResultSet(rs);
        return tables;
    }

    public static String getPkName(String ds, String table) {
        ResultSet rs;
        block7: {
            String string;
            block6: {
                DatabaseMetaData md;
                rs = null;
                String schemaPattern = null;
                if (xx.isOracle()) {
                    schemaPattern = DsUtil.getUserNameByConfigName(ds);
                }
                if ((rs = (md = DsUtil.getDatabaseMetaData(ds)).getPrimaryKeys(null, schemaPattern, table)) != null) break block6;
                String string2 = null;
                DsUtil.closeResultSet(rs);
                return string2;
            }
            try {
                if (!rs.next()) break block7;
                string = rs.getString("COLUMN_NAME");
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DsUtil.closeResultSet(rs);
                    throw throwable;
                }
            }
            DsUtil.closeResultSet(rs);
            return string;
        }
        DsUtil.closeResultSet(rs);
        return null;
    }

    public static JSONArray getColumnInfoByConfigName(String ds, String tableNamePattern) {
        JSONArray array = new JSONArray();
        ResultSet rs = null;
        try {
            Properties props = null;
            if (xx.isMysql()) {
                props = new Properties();
                props.setProperty("REMARKS", "true");
                props.setProperty("COLUMN_DEF", "true");
            }
            DatabaseMetaData md = DsUtil.getDatabaseMetaData(ds, props);
            String schemaPattern = null;
            if (xx.isOracle()) {
                schemaPattern = DsUtil.getUserNameByConfigName(ds);
            }
            rs = md.getColumns(null, schemaPattern, tableNamePattern, null);
            List comments = null;
            if (xx.isOracle()) {
                String userName = DsUtil.getUserNameByConfigName(ds);
                String sql = "select column_name,comments from all_col_comments where owner = ? and table_name = ?";
                comments = Db.use((String)ds).find(sql, new Object[]{userName, tableNamePattern});
            }
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                JSONObject json = new JSONObject();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metaData.getColumnLabel(i);
                    String value = rs.getString(columnName);
                    json.put(columnName, (Object)value);
                }
                if (xx.isOracle() && comments != null) {
                    json.put("REMARKS", (Object)DsUtil.getOracleRemark(comments, json.getString("COLUMN_NAME")));
                }
                array.add((Object)json);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DsUtil.closeResultSet(rs);
                throw throwable;
            }
        }
        DsUtil.closeResultSet(rs);
        return array;
    }

    private static void closeConn(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static String getOracleRemark(List<Record> comments, String en) {
        for (Record x : comments) {
            if (!en.equals(x.getStr("column_name").toLowerCase())) continue;
            return x.getStr("comments");
        }
        return null;
    }
}

