/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.utils.excel;

import com.eova.common.utils.util.RandomUtil;
import com.eova.common.utils.xx;
import com.eova.model.MetaField;
import com.eova.model.MetaObject;
import com.jfinal.plugin.activerecord.Record;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class ExcelUtil {
    public static void createExcel(OutputStream os, List<Record> list, List<MetaField> items, MetaObject object) throws WriteException, IOException {
        WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)os);
        WritableSheet sheet = workbook.createSheet("Sheet1", 0);
        int row = 0;
        for (int i = 0; i < items.size(); ++i) {
            MetaField item = items.get(i);
            WritableCellFormat format = new WritableCellFormat();
            format.setBackground(Colour.GRAY_25);
            sheet.addCell((WritableCell)new Label(i, row, item.getCn(), (CellFormat)format));
            sheet.setColumnView(i, item.getInt("width") / 10);
        }
        ++row;
        while (row <= list.size()) {
            Record record = list.get(row - 1);
            String[] values = ExcelUtil.getValues(items, record);
            for (int i = 0; i < values.length; ++i) {
                sheet.addCell((WritableCell)new Label(i, row, values[i]));
            }
            ++row;
        }
        workbook.write();
        workbook.close();
    }

    private static String[] getValues(List<MetaField> items, Record record) {
        String[] values = new String[items.size()];
        int i = -1;
        for (MetaField item : items) {
            ++i;
            Object value = record.get(item.getEn());
            if (value == null) continue;
            values[i] = value.toString();
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Record> importExcel(InputStream is, List<MetaField> items) {
        ArrayList<Record> list = new ArrayList<Record>();
        try (Workbook workbook = null;){
            workbook = Workbook.getWorkbook((InputStream)is);
            Sheet readsheet = workbook.getSheet(0);
            int colSum = readsheet.getColumns();
            int rowSum = readsheet.getRows();
            String[] headers = new String[colSum];
            Map<String, String> field = ExcelUtil.getKeyValue(items);
            int row = 0;
            for (int i = 0; i < colSum; ++i) {
                Cell cell = readsheet.getCell(i, 0);
                headers[i] = cell.getContents();
            }
            ++row;
            while (row < rowSum) {
                Record record = new Record();
                for (int i = 0; i < colSum; ++i) {
                    Cell cell = readsheet.getCell(i, row);
                    String s = cell.getContents();
                    if (xx.isEmpty(s)) continue;
                    record.set(field.get(headers[i]), (Object)s);
                }
                if (record.getColumns().isEmpty()) {
                    list.add(record);
                }
                ++row;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Record> importExcelByMergedCell(InputStream is, List<MetaField> items) {
        Object sheet1;
        String tempDir = System.getProperty("java.io.tmpdir");
        String tempName = System.currentTimeMillis() + RandomUtil.nextIntAsStringByLength(3) + ".xls";
        String tempPath = tempDir + File.separator + tempName;
        File tempXls = new File(tempPath);
        Workbook wb = null;
        WritableWorkbook wwb = null;
        try {
            wb = Workbook.getWorkbook((InputStream)is);
            wwb = Workbook.createWorkbook((File)tempXls);
            Sheet sheet = wb.getSheet(0);
            sheet1 = wwb.createSheet("temp", 0);
            Range[] rangeCell = sheet.getMergedCells();
            for (int i = 0; i < sheet.getRows(); ++i) {
                for (int j = 0; j < sheet.getColumns(); ++j) {
                    String str = sheet.getCell(j, i).getContents();
                    for (Range r : rangeCell) {
                        if (i <= r.getTopLeft().getRow() || i > r.getBottomRight().getRow() || j < r.getTopLeft().getColumn() || j > r.getBottomRight().getColumn()) continue;
                        str = sheet.getCell(r.getTopLeft().getColumn(), r.getTopLeft().getRow()).getContents();
                    }
                    Label label = new Label(j, i, str);
                    sheet1.addCell((WritableCell)label);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                wwb.write();
                wwb.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            wb.close();
        }
        FileInputStream tempIs = null;
        try {
            tempIs = new FileInputStream(tempXls);
            sheet1 = ExcelUtil.importExcel(tempIs, items);
            return sheet1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (tempIs != null) {
                try {
                    ((InputStream)tempIs).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (tempXls.exists()) {
                tempXls.delete();
            }
        }
        return null;
    }

    private static Map<String, String> getKeyValue(List<MetaField> items) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (MetaField item : items) {
            if (item.isVirtual()) continue;
            map.put(item.getCn(), item.getEn());
        }
        return map;
    }

    public static void writeExcel(InputStream is, OutputStream os, HashMap<String, String> data) throws Exception {
        WritableWorkbook wwb = null;
        WorkbookSettings settings = new WorkbookSettings();
        settings.setEncoding("UTF-8");
        settings.setWriteAccess("eovaxls");
        Workbook in = Workbook.getWorkbook((InputStream)is, (WorkbookSettings)settings);
        wwb = Workbook.createWorkbook((OutputStream)os, (Workbook)in);
        WritableSheet sheet = wwb.getSheet(1);
        int colSum = sheet.getColumns();
        int rowSum = sheet.getRows();
        System.out.println(colSum);
        System.out.println(rowSum);
        sheet.addCell((WritableCell)new Label(1, 1, "6666666"));
        Cell cell = sheet.getCell(1, 1);
        System.out.println(cell.getContents());
        wwb.write();
        wwb.close();
    }
}

