/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.utils.io;

import com.eova.common.utils.xx;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class FileUtil {
    public static final String IMG_TYPE = ".jpeg|.jpg|.gif|.png|.bmp";
    public static String ALL_TYPE = ".jpg|.jpeg|.gif|.png|.bmp|.gz|.7z|.rar|.zip|.swf|.mp3|.mp4|.jar|.apk|.ipa|.doc|.docx|.xls|.xlsx|.ppt|.pptx|.pdf|.txt";

    public static String formatPath(String path) {
        if (path.contains("/")) {
            path = path.replace("/", File.separator);
        }
        if (path.contains("\\")) {
            path = path.replace("/", File.separator);
        }
        return path;
    }

    public static boolean checkFileSize(File file, int mb) {
        long size = file.length();
        return size > (long)(0x100000 * mb);
    }

    public static boolean checkFileType(String fileName, boolean isImg) {
        String fileType = FileUtil.getFileType(fileName);
        if (isImg) {
            return IMG_TYPE.indexOf(fileType.toLowerCase()) != -1;
        }
        return xx.getConfig("upload_type", ALL_TYPE).indexOf(fileType.toLowerCase()) != -1;
    }

    public static String getFileType(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."), fileName.length());
    }

    public static boolean isExists(String path) {
        File file = new File(path);
        return file.exists() && file.length() > 0L;
    }

    public static boolean isDir(String path) {
        File file = new File(path);
        return file.exists() && file.isDirectory();
    }

    public static void delete(String path) {
        FileUtil.delete(new File(path));
    }

    public static void delete(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    public static void rename(String path, String toPath) throws IOException {
        File toBeRenamed = new File(path);
        if (!toBeRenamed.exists() || toBeRenamed.isDirectory()) {
            throw new IOException("File does not exist: " + path);
        }
        File newFile = new File(toPath);
        if (!toBeRenamed.renameTo(newFile)) {
            throw new IOException("rename error");
        }
    }

    public static void copy(String path, String toPath) throws IOException {
        FileInputStream ins = new FileInputStream(path);
        FileOutputStream out = new FileOutputStream(toPath);
        byte[] b = new byte[1024];
        int n = 0;
        while ((n = ins.read(b)) != -1) {
            out.write(b, 0, n);
        }
        ins.close();
        out.close();
    }

    public static File[] getFiles(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file.listFiles();
        }
        return null;
    }

    public static Properties getProp(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(new InputStreamReader((InputStream)inputStream, "UTF-8"));
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.formatPath("C:\\static\\img/product"));
        System.out.println(FileUtil.formatPath("C:/static/img/product"));
        System.out.println(FileUtil.formatPath("home/static/img/product"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteToFile(byte[] data, String fileDir, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(fileDir);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(fileDir + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

