/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.utils.io;

import com.eova.common.utils.xx;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;

public class ZipUtil {
    public static File[] unzip(String zip, String dest, String passwd) throws ZipException {
        File zipFile = new File(zip);
        return ZipUtil.unzip(zipFile, dest, passwd);
    }

    public static File[] unzip(String zip, String passwd) throws ZipException {
        File zipFile = new File(zip);
        File parentDir = zipFile.getParentFile();
        return ZipUtil.unzip(zipFile, parentDir.getAbsolutePath(), passwd);
    }

    public static File[] unzip(File zipFile, String dest, String passwd) throws ZipException {
        ZipFile zFile = new ZipFile(zipFile);
        zFile.setFileNameCharset("GBK");
        if (!zFile.isValidZipFile()) {
            throw new ZipException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5408\u6cd5,\u53ef\u80fd\u88ab\u635f\u574f.");
        }
        File destDir = new File(dest);
        if (destDir.isDirectory() && !destDir.exists()) {
            destDir.mkdir();
        }
        if (zFile.isEncrypted()) {
            zFile.setPassword(passwd.toCharArray());
        }
        zFile.extractAll(dest);
        List headerList = zFile.getFileHeaders();
        ArrayList<File> extractedFileList = new ArrayList<File>();
        for (FileHeader fileHeader : headerList) {
            if (fileHeader.isDirectory()) continue;
            extractedFileList.add(new File(destDir, fileHeader.getFileName()));
        }
        File[] extractedFiles = new File[extractedFileList.size()];
        extractedFileList.toArray(extractedFiles);
        return extractedFiles;
    }

    public static String zip(String src) {
        return ZipUtil.zip(src, null);
    }

    public static String zip(String src, String passwd) {
        return ZipUtil.zip(src, null, passwd);
    }

    public static String zip(String src, String dest, String passwd) {
        return ZipUtil.zip(src, dest, true, passwd);
    }

    public static String zip(String src, String dest, boolean isCreateDir, String passwd) {
        File srcFile = new File(src);
        dest = ZipUtil.buildDestinationZipFilePath(srcFile, dest);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        if (!xx.isEmpty(passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(passwd.toCharArray());
        }
        try {
            ZipFile zipFile = new ZipFile(dest);
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = new ArrayList();
                    Collections.addAll(temp, subFiles);
                    zipFile.addFiles(temp, parameters);
                    return dest;
                }
                zipFile.addFolder(srcFile, parameters);
            } else {
                zipFile.addFile(srcFile, parameters);
            }
            return dest;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String buildDestinationZipFilePath(File srcFile, String destParam) {
        if (xx.isEmpty(destParam)) {
            if (srcFile.isDirectory()) {
                destParam = srcFile.getParent() + File.separator + srcFile.getName() + ".zip";
            } else {
                String fileName = srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = srcFile.getParent() + File.separator + fileName + ".zip";
            }
        } else {
            ZipUtil.createDestDirectoryIfNecessary(destParam);
            if (destParam.endsWith(File.separator)) {
                String fileName = "";
                fileName = srcFile.isDirectory() ? srcFile.getName() : srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = destParam + fileName + ".zip";
            }
        }
        return destParam;
    }

    private static void createDestDirectoryIfNecessary(String destParam) {
        File destDir = null;
        destDir = destParam.endsWith(File.separator) ? new File(destParam) : new File(destParam.substring(0, destParam.lastIndexOf(File.separator)));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
    }

    public static void main(String[] args) {
        ZipUtil.zip("d:\\test\\cc", "d:\\test\\cc.zip", "11");
    }
}

