/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.utils.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    public static final String YYYY = "yyyy";
    public static final String MM = "MM";
    public static final String DD = "dd";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static String formatStr_yyyyMMddHHmmssS = "yyyy-MM-dd HH:mm:ss.S";
    public static String formatStr_yyyyMMddHHmmss = "yyyy-MM-dd HH:mm:ss";
    public static String formatStr_yyyyMMddHHmmss1 = "yyyyMMddHHmmss";
    public static String formatStr_yyyyMMddHHmm = "yyyy-MM-dd HH:mm";
    public static String formatStr_yyyyMMddHH = "yyyy-MM-dd HH";
    public static String formatStr_yyyyMMdd = "yyyy-MM-dd";
    public static String[] formatStr = new String[]{formatStr_yyyyMMddHHmmss, formatStr_yyyyMMddHHmm, formatStr_yyyyMMddHH, formatStr_yyyyMMdd};

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        return DateUtil.getFormatter(pattern).format(date);
    }

    public static String format(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtil.getFormatter(YYYY_MM_DD).format(date);
    }

    public static Date format(String strDate) {
        Date d = null;
        if (strDate == "") {
            return null;
        }
        try {
            d = DateUtil.getFormatter(YYYY_MM_DD).parse(strDate);
        }
        catch (ParseException pex) {
            return null;
        }
        return d;
    }

    public static Date format(String strDate, String f) {
        Date d = null;
        if (strDate == "") {
            return null;
        }
        try {
            d = DateUtil.getFormatter(f).parse(strDate);
        }
        catch (ParseException pex) {
            return null;
        }
        return d;
    }

    public static Date parse(String strDate, String pattern) throws ParseException {
        try {
            return DateUtil.getFormatter(pattern).parse(strDate);
        }
        catch (ParseException pe) {
            throw new ParseException("Method parse in Class DateUtil err: parse strDate fail.", pe.getErrorOffset());
        }
    }

    public static synchronized Date getCurrDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static String getCurrDateStr() {
        return DateUtil.format(DateUtil.getCurrDate(), YYYY_MM_DD);
    }

    public static String getCurrTimeStr() {
        return DateUtil.format(DateUtil.getCurrDate(), HH_MM_SS);
    }

    public static String getCurrDateTimeStr() {
        return DateUtil.format(DateUtil.getCurrDate(), YYYY_MM_DD_HH_MM_SS);
    }

    public static String getYear() {
        return DateUtil.format(DateUtil.getCurrDate(), YYYY);
    }

    public static String getMonth() {
        return DateUtil.format(DateUtil.getCurrDate(), MM);
    }

    public static String getDay() {
        return DateUtil.format(DateUtil.getCurrDate(), DD);
    }

    public static boolean isDate(String strDate, String pattern) {
        try {
            DateUtil.parse(strDate, pattern);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static boolean isYYYY(String strDate) {
        try {
            DateUtil.parse(strDate, YYYY);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static boolean isYYYY_MM(String strDate) {
        try {
            DateUtil.parse(strDate, YYYY_MM);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static boolean isYYYY_MM_DD(String strDate) {
        try {
            DateUtil.parse(strDate, YYYY_MM_DD);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static boolean isYYYY_MM_DD_HH_MM_SS(String strDate) {
        try {
            DateUtil.parse(strDate, YYYY_MM_DD_HH_MM_SS);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static boolean isHH_MM_SS(String strDate) {
        try {
            DateUtil.parse(strDate, HH_MM_SS);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    private static SimpleDateFormat getFormatter(String parttern) {
        return new SimpleDateFormat(parttern);
    }

    public static String getNextDate(String refenceDate, int intevalDays) {
        try {
            return DateUtil.getNextDate(DateUtil.parse(refenceDate, YYYY_MM_DD), intevalDays);
        }
        catch (Exception ee) {
            return "";
        }
    }

    public static String getNextDate(Date refenceDate, int intevalDays) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(refenceDate);
            calendar.set(5, calendar.get(5) + intevalDays);
            return DateUtil.format(calendar.getTime(), YYYY_MM_DD);
        }
        catch (Exception ee) {
            return "";
        }
    }

    public static long getIntevalDays(String startDate, String endDate) {
        try {
            return DateUtil.getIntevalDays(DateUtil.parse(startDate, YYYY_MM_DD), DateUtil.parse(endDate, YYYY_MM_DD));
        }
        catch (Exception ee) {
            return 0L;
        }
    }

    public static long getIntevalDays(Date startDate, Date endDate) {
        try {
            Calendar startCalendar = Calendar.getInstance();
            Calendar endCalendar = Calendar.getInstance();
            startCalendar.setTime(startDate);
            endCalendar.setTime(endDate);
            long diff = endCalendar.getTimeInMillis() - startCalendar.getTimeInMillis();
            return diff / 86400000L;
        }
        catch (Exception ee) {
            return 0L;
        }
    }

    public static long getTodayIntevalDays(String startDate) {
        try {
            Date currentDate = new Date();
            SimpleDateFormat myFormatter = new SimpleDateFormat(YYYY_MM_DD);
            Date theDate = myFormatter.parse(startDate);
            long days = (currentDate.getTime() - theDate.getTime()) / 86400000L;
            return days;
        }
        catch (Exception ee) {
            return 0L;
        }
    }

    public static Date parseToDate(String dateTimeStr) {
        if (dateTimeStr == null) {
            return null;
        }
        Date d = null;
        int formatStrLength = formatStr.length;
        for (int i = 0; i < formatStrLength && (d = DateUtil.parseToDate2(dateTimeStr, formatStr[i])) == null; ++i) {
        }
        return d;
    }

    private static Date parseToDate2(String dateTimeStr, String formatString) {
        Date d = null;
        SimpleDateFormat sdf = new SimpleDateFormat(formatString);
        try {
            d = sdf.parse(dateTimeStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return d;
    }

    public static String dateTimeToString(Date datetime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(datetime);
        String dateTime = calendar.get(1) + "" + (calendar.get(2) + 1 > 9 ? "" : "0") + (calendar.get(2) + 1) + "" + (calendar.get(5) > 9 ? "" : "0") + calendar.get(5) + "" + (calendar.get(11) > 9 ? "" : "0") + calendar.get(11) + "" + (calendar.get(12) > 9 ? "" : "0") + calendar.get(12) + "" + (calendar.get(13) > 9 ? "" : "0") + calendar.get(13);
        return dateTime;
    }

    public static String getLastDayOfMonth(String year, String month) throws ParseException {
        String LastDay = "";
        Calendar cal = Calendar.getInstance();
        Date date = new SimpleDateFormat(YYYY_MM_DD).parse(year + "-" + month + "-14");
        cal.setTime(date);
        int value = cal.getActualMaximum(5);
        cal.set(5, value);
        Date date_ = cal.getTime();
        LastDay = new SimpleDateFormat(YYYY_MM_DD).format(date_);
        return LastDay;
    }

    public static void main(String[] args) {
        try {
            System.out.println("\u5f53\u524d\u65e5\u671f\uff1a" + DateUtil.getCurrDateStr());
            System.out.println("\u65e5\u671f\u683c\u5f0f\u5316\uff1a" + DateUtil.format(new Date(), formatStr_yyyyMMddHHmmss1));
            System.out.println("\u77ed\u65e5\u671f\uff1a" + DateUtil.format(new Date()));
            System.out.println("\u957f\u65e5\u671f\uff1a" + DateUtil.getCurrDateTimeStr());
            System.out.println("\u65e5\uff1a" + DateUtil.getDay());
            System.out.println("\u6708\uff1a" + DateUtil.getMonth());
            System.out.println("\u5e74\uff1a" + DateUtil.getYear());
            System.out.println("\u6708\u672a\u6700\u540e\u4e00\u5929\uff1a" + DateUtil.getLastDayOfMonth("2010", "08"));
            System.out.println("\u76f8\u5dee\u51e0\u5929\uff1a" + DateUtil.getIntevalDays("2010-08-01", "2010-08-21"));
            System.out.println("\u5f53\u524d\u65e5\u671f\u540e\u7684\u51e0\u5929\uff1a" + DateUtil.getNextDate("2010-08-01", -3));
            System.out.println("\u4e0e\u4eca\u5929\u76f8\u5dee\u51e0\u5929\uff1a" + DateUtil.getTodayIntevalDays("2010-08-01"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

