/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.utils.web;

import com.eova.common.utils.xx;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    public static Map getParameterMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator entries = properties.entrySet().iterator();
        String name = "";
        String value = "";
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }

    public static String getLastUrl(HttpServletRequest request, Map<String, String> noReturnMaping) {
        String url = request.getHeader("Referer");
        if (url == null) {
            return "/";
        }
        for (Map.Entry<String, String> entry : noReturnMaping.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (!url.contains(key.toString())) continue;
            return val.toString();
        }
        return url;
    }

    public static String getReferer(HttpServletRequest request) {
        return request.getHeader("Referer");
    }

    public static String getUserAgent(HttpServletRequest request) {
        if (xx.isEmpty(request.getHeader("User-Agent"))) {
            return "";
        }
        return request.getHeader("User-Agent");
    }

    public static String getNginxProxyIp(HttpServletRequest request) {
        return request.getHeader("X-Real-IP");
    }

    public static String getIp(HttpServletRequest request) {
        String ip = RequestUtil.getNginxProxyIp(request);
        if (xx.isEmpty(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

