/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.utils.web;

import com.jfinal.kit.LogKit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class WebUtil {
    public static String readData(HttpServletRequest request, String charSet) {
        ServletInputStream in = null;
        StringBuilder sb = new StringBuilder();
        try {
            in = request.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, charSet));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogKit.error((String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String readData(HttpServletRequest request) {
        return WebUtil.readData(request, "UTF-8");
    }

    public static String getRealIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.indexOf(",") > -1) {
            ip = ip.split(",")[0];
        }
        return ip;
    }
}

