/*
 * Decompiled with CFR 0.152.
 */
package com.eova.common.utils;

import com.eova.config.EovaConfig;
import java.io.File;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class xx {
    public static final String DS_MAIN = "main";
    public static final String DS_EOVA = "eova";

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        if (o instanceof Iterator) {
            return !((Iterator)o).hasNext();
        }
        if (o instanceof Iterable) {
            return !((Iterable)o).iterator().hasNext();
        }
        return o instanceof String && o.toString().equals("");
    }

    public static boolean isOneEmpty(Object ... os) {
        for (Object o : os) {
            if (!xx.isEmpty(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... os) {
        for (Object o : os) {
            if (xx.isEmpty(o)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNum(Object obj) {
        try {
            Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isTrue(Object str) {
        if (xx.isEmpty(str)) {
            return false;
        }
        return (str = str.toString().trim().toLowerCase()).equals("true") || str.equals("on");
    }

    public static String format(Object str) {
        return "'" + str.toString() + "'";
    }

    public static String formatPath(String path, Object ... args) {
        return String.format(path.replace("/", File.separator), args);
    }

    public static Integer toInt(Object obj) {
        return Integer.parseInt(obj.toString());
    }

    public static Integer toInt(Object obj, int defaultValue) {
        if (xx.isEmpty(obj)) {
            return defaultValue;
        }
        return xx.toInt(obj);
    }

    public static long toLong(Object obj) {
        return Long.parseLong(obj.toString());
    }

    public static long toLong(Object obj, long defaultValue) {
        if (xx.isEmpty(obj)) {
            return defaultValue;
        }
        return xx.toLong(obj);
    }

    public static double toDouble(Object obj) {
        return Double.parseDouble(obj.toString());
    }

    public static Boolean toBoolean(Object obj) {
        return Boolean.parseBoolean(obj.toString());
    }

    public static Boolean toBoolean(Object obj, Boolean defaultValue) {
        if (xx.isEmpty(obj)) {
            return defaultValue;
        }
        return xx.toBoolean(obj);
    }

    public static Date toDate(String str) {
        try {
            if (str == null || "".equals(str.trim())) {
                return null;
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(str.trim());
        }
        catch (Exception e) {
            throw new RuntimeException("Can not parse the parameter \"" + str + "\" to Date value.");
        }
    }

    public static boolean isOracle() {
        return EovaConfig.EOVA_DBTYPE.equals("oracle");
    }

    public static boolean isMysql() {
        return EovaConfig.EOVA_DBTYPE.equals("mysql");
    }

    public static String join(Collection<?> s) {
        return xx.join(s, "", ",");
    }

    public static String join(Collection<?> s, String parcel, String sign) {
        if (s.isEmpty()) {
            return "";
        }
        Iterator<?> iter = s.iterator();
        StringBuilder sb = new StringBuilder(parcel + iter.next().toString() + parcel);
        while (iter.hasNext()) {
            sb.append(sign).append(parcel + iter.next() + parcel);
        }
        return sb.toString();
    }

    public static String delStart(String s, String sign) {
        if (s.startsWith(sign)) {
            return s.substring(s.lastIndexOf(sign) + sign.length(), s.length());
        }
        return s;
    }

    public static String delEnd(String s, String sign) {
        if (xx.isEmpty(s)) {
            return s;
        }
        if (s.endsWith(sign)) {
            return s.substring(0, s.lastIndexOf(sign));
        }
        return s;
    }

    public static String getConfig(String key) {
        String value = EovaConfig.getProps().get(key);
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public static String getConfig(String key, String defaultValue) {
        String value = EovaConfig.getProps().get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static boolean getConfigBool(String key, boolean defaultValue) {
        return xx.toBoolean(xx.getConfig(key), defaultValue);
    }

    public static int getConfigInt(String key, int defaultValue) {
        return xx.toInt(xx.getConfig(key), defaultValue);
    }

    public static void costTime(long time) {
        System.err.println("Load Cost Time:" + (System.currentTimeMillis() - time) + "ms\n");
    }

    public static String formatJson(String json) {
        int level = 0;
        StringBuffer sb = new StringBuffer();
        block5: for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (level > 0 && '\n' == sb.charAt(sb.length() - 1)) {
                sb.append(xx.getLevelStr(level));
            }
            switch (c) {
                case '[': 
                case '{': {
                    sb.append(c + "\n");
                    ++level;
                    continue block5;
                }
                case ',': {
                    sb.append(c + "\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    sb.append("\n");
                    sb.append(xx.getLevelStr(--level));
                    sb.append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String getLevelStr(int level) {
        StringBuffer levelStr = new StringBuffer();
        for (int levelI = 0; levelI < level; ++levelI) {
            levelStr.append("  ");
        }
        return levelStr.toString();
    }

    public static String replaceBlank(String s) {
        if (xx.isEmpty(s)) {
            return s;
        }
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(s);
        return m.replaceAll("");
    }

    public static boolean isTimeout(Long oldTime, int timeoutSec) {
        if (oldTime == null) {
            return true;
        }
        return (System.currentTimeMillis() - oldTime) / 1000L > (long)timeoutSec;
    }
}

