/*
 * Decompiled with CFR 0.152.
 */
package com.eova.config;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.wall.WallFilter;
import com.eova.cloud.AuthCloud;
import com.eova.common.plugin.quartz.QuartzPlugin;
import com.eova.common.utils.xx;
import com.eova.config.EovaInit;
import com.eova.config.PageConst;
import com.eova.core.IndexController;
import com.eova.core.auth.AuthController;
import com.eova.core.button.ButtonController;
import com.eova.core.menu.MenuController;
import com.eova.core.meta.MetaController;
import com.eova.core.task.TaskController;
import com.eova.ext.jfinal.EovaDbPro;
import com.eova.ext.jfinal.EovaOracleDialect;
import com.eova.handler.UrlBanHandler;
import com.eova.interceptor.AuthInterceptor;
import com.eova.interceptor.LoginInterceptor;
import com.eova.model.Button;
import com.eova.model.EovaLog;
import com.eova.model.Menu;
import com.eova.model.MetaField;
import com.eova.model.MetaObject;
import com.eova.model.Role;
import com.eova.model.RoleBtn;
import com.eova.model.Task;
import com.eova.model.User;
import com.eova.model.Widget;
import com.eova.service.ServiceManager;
import com.eova.template.masterslave.MasterSlaveController;
import com.eova.template.office.OfficeController;
import com.eova.template.single.SingleController;
import com.eova.template.singlechart.SingleChartController;
import com.eova.template.singletree.SingleTreeController;
import com.eova.template.treetogrid.TreeToGridController;
import com.eova.widget.WidgetController;
import com.eova.widget.form.FormController;
import com.eova.widget.grid.GridController;
import com.eova.widget.tree.TreeController;
import com.eova.widget.treegrid.TreeGridController;
import com.eova.widget.upload.UploadController;
import com.jfinal.aop.Interceptor;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.handler.Handler;
import com.jfinal.json.IJsonFactory;
import com.jfinal.json.MixedJsonFactory;
import com.jfinal.kit.LogKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.CaseInsensitiveContainerFactory;
import com.jfinal.plugin.activerecord.DbPro;
import com.jfinal.plugin.activerecord.IContainerFactory;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.IDbProFactory;
import com.jfinal.plugin.activerecord.dialect.AnsiSqlDialect;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import com.jfinal.plugin.activerecord.dialect.PostgreSqlDialect;
import com.jfinal.plugin.activerecord.dialect.SqlServerDialect;
import com.jfinal.plugin.druid.DruidPlugin;
import com.jfinal.plugin.druid.DruidStatViewHandler;
import com.jfinal.plugin.ehcache.EhCachePlugin;
import com.jfinal.render.IRenderFactory;
import com.jfinal.template.Engine;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.beetl.core.GroupTemplate;
import org.beetl.ext.jfinal3.JFinal3BeetlRenderFactory;

public class EovaConfig
extends JFinalConfig {
    public static boolean isDevMode = true;
    public static String EOVA_DBTYPE = "mysql";
    public static boolean isLowerCase = true;
    protected static Map<String, String> props = new HashMap<String, String>();
    protected static Set<String> dataSources = new HashSet<String>();
    protected static Map<String, String> exps = new HashMap<String, String>();
    protected static Map<Integer, Set<String>> authUris = new HashMap<Integer, Set<String>>();
    protected static Map<String, Set<String>> authFields = new HashMap<String, Set<String>>();
    private static HashMap<String, ActiveRecordPlugin> arps = new HashMap();
    private long startTime = 0L;

    public static Map<String, String> getProps() {
        return props;
    }

    public static Set<String> getDataSources() {
        return dataSources;
    }

    public static Map<String, String> getExps() {
        return exps;
    }

    public static Map<Integer, Set<String>> getAuthUris() {
        return authUris;
    }

    public static Map<String, Set<String>> getAuthFields() {
        return authFields;
    }

    public void afterJFinalStart() {
        System.err.println("JFinal Started\n");
        xx.costTime(this.startTime);
        EovaInit.initSource();
        Boolean isInit = xx.getConfigBool("initPlugins", true);
        if (isInit.booleanValue()) {
            EovaInit.initPlugins();
        }
        if ((isInit = Boolean.valueOf(xx.getConfigBool("initSql", false))).booleanValue() && EOVA_DBTYPE.equals("mysql")) {
            EovaInit.initCreateSql();
        }
    }

    public void beforeJFinalStop() {
    }

    public void configConstant(Constants me) {
        this.startTime = System.currentTimeMillis();
        System.err.println("Config Constants Starting...");
        me.setEncoding("UTF-8");
        EovaInit.initConfig(props);
        isDevMode = xx.getConfigBool("devMode", true);
        me.setDevMode(isDevMode);
        me.setMaxPostSize(524288000);
        me.setError500View("/eova/500.html");
        me.setError404View("/eova/404.html");
        me.setBaseUploadPath(xx.getConfig("static_root"));
        me.setJsonFactory((IJsonFactory)new MixedJsonFactory());
        String STATIC = props.get("domain_static");
        String CDN = props.get("domain_cdn");
        String IMG = props.get("domain_img");
        String FILE = props.get("domain_file");
        HashMap<String, Object> sharedVars = new HashMap<String, Object>();
        if (!xx.isEmpty(STATIC)) {
            sharedVars.put("STATIC", STATIC);
        } else {
            sharedVars.put("STATIC", "");
        }
        if (!xx.isEmpty(CDN)) {
            sharedVars.put("CDN", CDN);
        }
        if (!xx.isEmpty(IMG)) {
            sharedVars.put("IMG", IMG);
        }
        if (!xx.isEmpty(FILE)) {
            sharedVars.put("FILE", FILE);
        }
        sharedVars.put("APP", AuthCloud.getEovaApp());
        PageConst.init(sharedVars);
        JFinal3BeetlRenderFactory rf = new JFinal3BeetlRenderFactory();
        rf.config();
        me.setRenderFactory((IRenderFactory)rf);
        GroupTemplate gt = rf.groupTemplate;
        gt.setSharedVars(sharedVars);
        this.exp();
        this.authUri();
        this.authField();
    }

    public void configRoute(Routes me) {
        System.err.println("Config Routes Starting...");
        me.add("/single_grid", SingleController.class);
        me.add("/single_tree", SingleTreeController.class);
        me.add("/single_chart", SingleChartController.class);
        me.add("/master_slave_grid", MasterSlaveController.class);
        me.add("/tree_grid", TreeToGridController.class);
        me.add("/office", OfficeController.class);
        me.add("/widget", WidgetController.class);
        me.add("/upload", UploadController.class);
        me.add("/form", FormController.class);
        me.add("/grid", GridController.class);
        me.add("/tree", TreeController.class);
        me.add("/treegrid", TreeGridController.class);
        me.add("/meta", MetaController.class);
        me.add("/menu", MenuController.class);
        me.add("/button", ButtonController.class);
        me.add("/auth", AuthController.class);
        me.add("/task", TaskController.class);
        LoginInterceptor.excludes.add("/cloud");
        this.route(me);
        boolean flag = false;
        for (Routes.Route x : me.getRouteItemList()) {
            if (!x.getControllerKey().equals("/")) continue;
            flag = true;
        }
        if (!flag) {
            me.add("/", IndexController.class);
        }
    }

    public void configEngine(Engine me) {
    }

    public void configPlugin(Plugins plugins) {
        System.err.println("Config Plugins Starting...");
        this.regDataSource(plugins);
        this.plugin(plugins);
        this.mappingEova(arps.get("eova"));
        this.mapping(arps);
        ServiceManager.init();
        plugins.add((IPlugin)new EhCachePlugin());
        boolean isQuartz = xx.getConfigBool("isQuartz", true);
        if (isQuartz) {
            QuartzPlugin quartz = new QuartzPlugin();
            plugins.add((IPlugin)quartz);
        }
    }

    private void regDataSource(Plugins plugins) {
        String datasource = xx.getConfig("db.datasource");
        if (xx.isEmpty(datasource)) {
            throw new RuntimeException("\u6570\u636e\u6e90\u914d\u7f6e\u9879\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u914d\u7f6e/default/jdbc.config \u914d\u7f6e\u9879[db.datasource]");
        }
        for (String ds : datasource.split(",")) {
            ds = ds.trim();
            String url = xx.getConfig(ds + ".url");
            String user = xx.getConfig(ds + ".user");
            String pwd = xx.getConfig(ds + ".pwd");
            DruidPlugin dp = this.initDruidPlugin(url, user, pwd);
            ActiveRecordPlugin arp = this.initActiveRecordPlugin(url, ds, (IDataSourceProvider)dp);
            LogKit.info((String)("load data source:" + url + " > " + user));
            dataSources.add(ds);
            arps.put(ds, arp);
            plugins.add((IPlugin)dp).add((IPlugin)arp);
        }
    }

    public void configInterceptor(Interceptors me) {
        System.err.println("Config Interceptors Starting...");
        me.add((Interceptor)new LoginInterceptor());
        me.add((Interceptor)new AuthInterceptor());
    }

    public void configHandler(Handlers me) {
        System.err.println("Config Handlers Starting...");
        DruidStatViewHandler dvh = new DruidStatViewHandler("/druid");
        me.add((Handler)dvh);
        me.add((Handler)new UrlBanHandler(".*\\.(html|tag)", false));
    }

    private void mappingEova(ActiveRecordPlugin arp) {
        arp.addMapping("eova_object", MetaObject.class);
        arp.addMapping("eova_field", MetaField.class);
        arp.addMapping("eova_button", Button.class);
        arp.addMapping("eova_menu", Menu.class);
        arp.addMapping("eova_user", User.class);
        arp.addMapping("eova_role", Role.class);
        arp.addMapping("eova_role_btn", RoleBtn.class);
        arp.addMapping("eova_log", EovaLog.class);
        arp.addMapping("eova_task", Task.class);
        arp.addMapping("eova_widget", Widget.class);
    }

    protected void mapping(HashMap<String, ActiveRecordPlugin> arps) {
    }

    protected void route(Routes me) {
    }

    protected void plugin(Plugins plugins) {
    }

    protected DruidPlugin initDruidPlugin(String url, String username, String password) {
        WallFilter wall = new WallFilter();
        String dbType = null;
        try {
            dbType = JdbcUtils.getDbType((String)url, (String)JdbcUtils.getDriverClassName((String)url));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        wall.setDbType(dbType);
        DruidPlugin dp = new DruidPlugin(url, username, password);
        dp.addFilter((Filter)new StatFilter());
        dp.addFilter((Filter)wall);
        return dp;
    }

    protected ActiveRecordPlugin initActiveRecordPlugin(String url, String ds, IDataSourceProvider dp) {
        Object dialect;
        int lv = xx.getConfigInt("db.transaction_level", 4);
        boolean isLowerCase = xx.getConfigBool("db.islowercase", true);
        boolean isShowSql = xx.getConfigBool("db.showsql", true);
        ActiveRecordPlugin arp = new ActiveRecordPlugin(ds, dp);
        arp.setDbProFactory(new IDbProFactory(){

            public DbPro getDbPro(String configName) {
                return new EovaDbPro(configName);
            }
        });
        String dbType = "";
        try {
            dbType = JdbcUtils.getDbType((String)url, (String)JdbcUtils.getDriverClassName((String)url));
            if (ds.equalsIgnoreCase("eova")) {
                EOVA_DBTYPE = dbType;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if ("mysql".equalsIgnoreCase(dbType) || "h2".equalsIgnoreCase(dbType)) {
            dialect = new MysqlDialect();
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            dialect = new EovaOracleDialect();
            ((DruidPlugin)dp).setValidationQuery("select 1 FROM DUAL");
        } else {
            dialect = "postgresql".equalsIgnoreCase(dbType) ? new PostgreSqlDialect() : ("sqlserver".equalsIgnoreCase(dbType) ? new SqlServerDialect() : new AnsiSqlDialect());
        }
        arp.setTransactionLevel(lv);
        arp.setContainerFactory((IContainerFactory)new CaseInsensitiveContainerFactory(isLowerCase));
        arp.setShowSql(isShowSql);
        arp.setDialect((Dialect)dialect);
        return arp;
    }

    protected void exp() {
        exps.put("selectEovaFieldByObjectCode", "select en Field,cn Name from eova_field where object_code = ?;ds=eova");
        exps.put("selectEovaRole", "select id id,name cn from eova_role;ds=eova");
    }

    protected void authUri() {
        HashSet<String> uris = new HashSet<String>();
        uris.add("/widget/**");
        uris.add("/upload/**");
        uris.add("/meta/object/**");
        uris.add("/meta/fields/**");
        authUris.put(0, uris);
    }

    protected void authField() {
        EovaConfig.addAuthField("eova_role_code.lv->1,2");
    }

    protected static void addAuthField(String auth) {
        String[] ss = auth.split("->");
        String key = ss[0];
        String b = ss[1];
        Set<String> set = authFields.get(key);
        if (set == null) {
            set = new HashSet<String>();
        }
        set.addAll(Arrays.asList(b.split(",")));
        authFields.put(key, set);
    }
}

