/*
 * Decompiled with CFR 0.152.
 */
package com.eova.config;

import com.eova.common.utils.db.DbUtil;
import com.eova.common.utils.io.FileUtil;
import com.eova.common.utils.io.NetUtil;
import com.eova.common.utils.io.ZipUtil;
import com.eova.common.utils.xx;
import com.eova.config.EovaConfig;
import com.eova.config.EovaConst;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class EovaInit {
    public static void initSource() {
        List dicts = Db.use((String)"eova").query("select value from eova_dict where object = ? and field = ?", new Object[]{"eova_object", "data_source"});
        for (String ds : EovaConfig.dataSources) {
            if (dicts.contains(ds)) continue;
            Record r = new Record();
            r.set("object", (Object)"eova_object");
            r.set("field", (Object)"data_source");
            r.set("value", (Object)ds);
            r.set("name", (Object)ds);
            Db.use((String)"eova").save("eova_dict", r);
        }
        for (String ds : dicts) {
            if (EovaConfig.dataSources.contains(ds)) continue;
            Db.use((String)"eova").update("delete from eova_dict where object = ? and field = ? and value = ?", new Object[]{"eova_object", "data_source", ds});
        }
    }

    public static void initPlugins() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    String zipPath = EovaConst.DIR_WEB + "plugins.zip";
                    if (!FileUtil.isExists(EovaConst.DIR_PLUGINS)) {
                        System.err.println("\u6b63\u5728\u4e0b\u8f7d\uff1ahttp://7xign9.com1.z0.glb.clouddn.com/eova_plugins.zip");
                        NetUtil.download("http://7xign9.com1.z0.glb.clouddn.com/eova_plugins.zip", zipPath);
                        System.err.println("\u5f00\u59cb\u89e3\u538b\uff1a" + zipPath);
                        ZipUtil.unzip(zipPath, EovaConst.DIR_PLUGINS, null);
                        System.err.println("\u5df2\u89e3\u538b\u5230\uff1a" + EovaConst.DIR_PLUGINS);
                        FileUtil.delete(zipPath);
                        System.err.println("\u6e05\u7406\u4e0b\u8f7dZip");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    public static void initCreateSql() {
        Thread t = new Thread(){

            @Override
            public void run() {
                System.out.println("\u6b63\u5728\u751f\u6210 eova oracle sql ing...");
                DbUtil.createOracleSql("eova", "EOVA%");
                System.out.println();
                System.out.println();
                System.out.println("\u6b63\u5728\u751f\u6210 web oracle sql ing...");
                DbUtil.createOracleSql("main", "%");
            }
        };
        t.start();
    }

    public static void initStatic() {
    }

    public static void initConfig(Map<String, String> props) {
        String resPath = PathKit.getRootClassPath() + File.separator;
        boolean flag = EovaInit.loadConfig(props, resPath + "default");
        if (flag) {
            LogKit.info((String)"\u9ed8\u8ba4\u914d\u7f6e\u52a0\u8f7d\u6210\u529f:(resources/default)\n");
        }
        if (flag = EovaInit.loadConfig(props, resPath + "dev")) {
            LogKit.info((String)"\u5f00\u53d1\u914d\u7f6e\u8986\u76d6\u6210\u529f:(resources/dev)\n");
        }
        try {
            String envConfigPath = xx.getConfig("env_config_path");
            if (!xx.isEmpty(envConfigPath) && (flag = EovaInit.loadConfig(props, envConfigPath))) {
                LogKit.info((String)String.format("\u73af\u5883\u914d\u7f6e\u8986\u76d6\u6210\u529f:%s\n", envConfigPath));
            }
        }
        catch (Exception e) {
            LogKit.error((String)String.format("\u52a0\u8f7d\u73af\u5883\u914d\u7f6e\u5f02\u5e38:%s", e.getMessage()));
        }
    }

    private static boolean loadConfig(Map<String, String> props, String path) {
        File[] files;
        if (!FileUtil.isDir(path)) {
            return false;
        }
        for (File file : files = FileUtil.getFiles(path)) {
            if (!file.getName().endsWith(".config")) continue;
            Properties properties = FileUtil.getProp(file);
            Set<Object> keySet = properties.keySet();
            for (Object ks : keySet) {
                String key = ks.toString();
                props.put(key, properties.getProperty(key));
            }
            LogKit.info((String)file.getName());
        }
        return true;
    }
}

