/*
 * Decompiled with CFR 0.152.
 */
package com.eova.core;

import com.eova.cloud.AuthCloud;
import com.eova.common.Easy;
import com.eova.common.utils.EncryptUtil;
import com.eova.common.utils.db.JdbcUtil;
import com.eova.common.utils.xx;
import com.eova.config.EovaConfig;
import com.eova.model.Button;
import com.eova.model.Menu;
import com.eova.model.User;
import com.eova.service.sm;
import com.eova.widget.WidgetUtil;
import com.jfinal.captcha.CaptchaRender;
import com.jfinal.core.Controller;
import com.jfinal.kit.JsonKit;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.render.Render;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IndexController
extends Controller {
    public void captcha() {
        this.render((Render)new CaptchaRender());
    }

    public void code() {
        this.setAttr("exp1", "select id UID,login_id CN from users where <%if(user.id != 0){%>  id > ${user.id}<%}%> order by id desc");
        this.render("/eova/code.html");
    }

    public void toIndex() {
        this.render("/eova/index.html");
    }

    public void header() {
        User user = (User)((Object)this.getSessionAttr("user"));
        this.setAttr("user", (Object)user);
        this.render("/eova/header.html");
    }

    public void footer() {
        this.render("/eova/footer.html");
    }

    public void toIcon() {
        this.render("/eova/icon.html");
    }

    public void ue() {
        this.render("/eova/uedemo.html");
    }

    public void form() {
        this.render("/eova/test/form.html");
    }

    public void toLogin() {
        boolean isCaptcha = xx.toBoolean(EovaConfig.getProps().get("isCaptcha"), true);
        this.setAttr("isCaptcha", isCaptcha);
        this.render("/eova/login.html");
    }

    public void toUpdatePwd() {
        User user = (User)((Object)this.getSessionAttr("user"));
        if (xx.isEmpty((Object)user)) {
            this.setAttr("msg", "\u8bf7\u5148\u767b\u5f55");
            this.toLogin();
            return;
        }
        this.render("/eova/updatePwd.html");
    }

    public void index() {
        String appId = xx.getConfig("app_id");
        String appSecret = xx.getConfig("app_secret");
        if (xx.isEmpty(appId)) {
            this.renderHtml("\u542f\u52a8\u4e4b\u524d\u8bf7\u5148\u914d\u7f6e\u5e94\u7528\u4fe1\u606f\uff1a<br>\u914d\u7f6e\u6587\u4ef6\uff1a/src/main/resources/default/app.config<br>\u5c0f\u8d34\u58eb\uff1a\u5e94\u7528ID\u548c\u5e94\u7528\u5bc6\u94a5\u5728\u3010Eova\u793e\u533a>\u6211\u7684\u9879\u76ee\u3011<br>\u7acb\u5373<a href=\"http://www.eova.cn/app\">\u514d\u8d39\u6ce8\u518c\u83b7\u53d6</a>");
            return;
        }
        if (!AuthCloud.isAuthApp(appId, appSecret)) {
            this.renderHtml("\u60a8\u4f7f\u7528\u4e86\u4e00\u4e2a\u65e0\u6548\u7684\u5e94\u7528ID\u6216\u5e94\u7528\u5bc6\u94a5\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\uff01<br>\u5e94\u7528ID\u548c\u5e94\u7528\u5bc6\u94a5\u5728\u3010Eova\u793e\u533a>\u6211\u7684\u9879\u76ee\u3011<br>\u7acb\u5373<a href=\"http://www.eova.cn/app\">\u514d\u8d39\u6ce8\u518c\u83b7\u53d6</a>");
            return;
        }
        User user = (User)((Object)this.getSessionAttr("user"));
        if (user != null) {
            this.setAttr("APP_MAIN", xx.getConfig("app_main"));
            this.setAttr("APP_MAIN_TITLE", xx.getConfig("app_main_title"));
            this.toIndex();
            return;
        }
        this.toLogin();
    }

    public void doExit() {
        this.removeSessionAttr("user");
        this.redirect("/");
    }

    public void doLogin() {
        String loginId = this.getPara("loginId");
        String loginPwd = this.getPara("loginPwd");
        boolean isCaptcha = xx.toBoolean(EovaConfig.getProps().get("isCaptcha"), true);
        if (isCaptcha && !super.validateCaptcha("captcha")) {
            this.setAttr("msg", "\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            this.toLogin();
            return;
        }
        String userDs = xx.getConfig("login.user.ds", "eova");
        String userTable = xx.getConfig("login.user.table", "eova_user");
        String userId = xx.getConfig("login.user.id", "id");
        String userAccount = xx.getConfig("login.user.account", "login_id");
        String userPassword = xx.getConfig("login.user.password", "login_pwd");
        String userRid = xx.getConfig("login.user.rid", "rid");
        Record r = Db.use((String)userDs).findFirst(String.format("select * from %s where %s = ?", userTable, userAccount), new Object[]{loginId});
        if (r == null) {
            this.setAttr("msg", "\u7528\u6237\u540d\u4e0d\u5b58\u5728");
            this.toLogin();
            return;
        }
        if (!r.getStr(userPassword).equals(EncryptUtil.getSM32(loginPwd))) {
            this.setAttr("msg", "\u5bc6\u7801\u9519\u8bef");
            this.keepPara(new String[]{"loginId"});
            this.toLogin();
            return;
        }
        User user = new User();
        user.set("id", r.get(userId));
        user.set("rid", r.getInt(userRid));
        user.set(userAccount, r.get(userAccount));
        try {
            this.loginInit(this, user);
            user.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setAttr("msg", e.getMessage());
            this.keepPara(new String[]{"loginId"});
            this.toLogin();
            return;
        }
        this.setSessionAttr("user", (Object)user);
        this.redirect("/");
    }

    protected void loginInit(Controller ctrl, User user) throws Exception {
        HashSet<String> auths = new HashSet<String>();
        String sql = "SELECT bs FROM eova_role_btn rf LEFT JOIN eova_button b ON rf.bid = b.id WHERE rf.rid = ?";
        List bss = Db.use((String)"eova").find(sql, new Object[]{user.getRid()});
        for (Record r : bss) {
            String[] strs;
            String bs = r.getStr("bs");
            if (xx.isEmpty(bs)) continue;
            if (!bs.contains(";")) {
                auths.add(bs);
                continue;
            }
            for (String str : strs = bs.split(";")) {
                auths.add(str);
            }
        }
        if (xx.isEmpty(auths)) {
            throw new Exception("\u7528\u6237\u89d2\u8272\u6ca1\u6709\u4efb\u4f55\u6388\u6743,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
        }
        user.put("auths", auths);
    }

    public void updatePwd() {
        String oldPwd = this.getPara("oldPwd");
        String newPwd = this.getPara("newPwd");
        String confirm = this.getPara("confirm");
        if (xx.isOneEmpty(oldPwd, newPwd, confirm)) {
            this.renderJson(new Easy("\u4e09\u4e2a\u5bc6\u7801\u90fd\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        if (!newPwd.equals(confirm)) {
            this.renderJson(new Easy("\u65b0\u5bc6\u7801\u4e24\u6b21\u8f93\u5165\u4e0d\u4e00\u81f4"));
            return;
        }
        User user = (User)((Object)this.getSessionAttr("user"));
        String pwd = user.getStr("login_pwd");
        if (!pwd.equals(EncryptUtil.getSM32(oldPwd))) {
            this.renderJson(new Easy("\u5bc6\u7801\u9519\u8bef"));
            return;
        }
        ((User)user.set("login_pwd", EncryptUtil.getSM32(newPwd))).update();
        this.renderJson(new Easy());
    }

    public void showTree() {
        Integer rootId = this.getParaToInt(0);
        if (rootId == null) {
            this.renderJson("\u7cfb\u7edf\u5f02\u5e38");
            return;
        }
        User user = (User)((Object)this.getSessionAttr("user"));
        int rid = user.getRid();
        LinkedHashMap allMenu = (LinkedHashMap)sm.auth.getByParentId(rootId);
        WidgetUtil.formatEasyTree(allMenu);
        List<String> authMenuCodeList = sm.auth.queryMenuCodeByRid(rid);
        LinkedHashMap authMenu = new LinkedHashMap();
        for (Map.Entry map : allMenu.entrySet()) {
            Menu menu = (Menu)((Object)map.getValue());
            if (!authMenuCodeList.contains(menu.getStr("code"))) continue;
            authMenu.put(map.getKey(), menu);
        }
        LinkedHashMap<Integer, Menu> authParent = new LinkedHashMap<Integer, Menu>();
        for (Map.Entry map : authMenu.entrySet()) {
            WidgetUtil.getParent(allMenu, authParent, (Menu)((Object)map.getValue()));
        }
        authParent.remove(rootId);
        authParent.putAll(authMenu);
        String json = WidgetUtil.menu2TreeJson(authParent, rootId);
        this.renderJson(json);
    }

    public void menu() {
        User user = (User)((Object)this.getSessionAttr("user"));
        List<Menu> menus = Menu.dao.queryMenu();
        List<Integer> ids = Button.dao.queryMenuIdByRid(user.getRid());
        HashSet<Integer> authPid = new HashSet<Integer>();
        for (Integer id : ids) {
            Menu m = IndexController.getParent(menus, id);
            this.findParent(authPid, menus, m);
        }
        Iterator<Menu> it = menus.iterator();
        while (it.hasNext()) {
            Menu m = it.next();
            m.put("link", m.getUrl());
            m.remove("url");
            Integer mid = m.getInt("id");
            if (authPid.contains(mid) || ids.contains(mid)) continue;
            it.remove();
        }
        this.renderJson(JsonKit.toJson(menus));
    }

    public void init() {
        this.render("/eova/init.html");
    }

    public void upgrade() {
        String isUpgrade = EovaConfig.getProps().get("isUpgrade");
        if (xx.isEmpty(isUpgrade) || !isUpgrade.equals("true")) {
            this.renderText("\u672a\u5f00\u542f\u5347\u7ea7\u6a21\u5f0f\uff0c\u8bf7\u542f\u52a8\u914d\u7f6e isUpgrade = true, \u7528\u5b8c\u4e4b\u540e\u7acb\u9a6c\u5173\u6389,\u540e\u679c\u81ea\u8d1f!");
            return;
        }
        this.render("/eova/help/upgrade.html");
    }

    public void doInit() {
        String ip = this.getPara("ip");
        String port = this.getPara("port");
        String userName = this.getPara("userName");
        String password = this.getPara("password");
        this.keepPara(new String[]{ip});
        this.keepPara(new String[]{port});
        this.keepPara(new String[]{userName});
        this.keepPara(new String[]{password});
        String local_url = MessageFormat.format("jdbc:mysql://{0}:{1}/web?characterEncoding=UTF-8&zeroDateTimeBehavior=convertToNull", ip, port);
        String msg = JdbcUtil.initConnection(local_url, userName, password);
        if (msg != null) {
            if (msg.startsWith("Communications link failure")) {
                msg = "\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93\uff0c\u8bf7\u68c0\u67e5IP:Port";
            } else if (msg.startsWith("Access denied for user")) {
                msg = "\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u548c\u5bc6\u7801";
            }
            this.setAttr("msg", msg);
            this.init();
            return;
        }
    }

    private static Menu getParent(List<Menu> menus, int id) {
        for (Menu m : menus) {
            if (m.getInt("id") != id) continue;
            return m;
        }
        return null;
    }

    private void findParent(HashSet<Integer> authPid, List<Menu> menus, Menu m) {
        if (m == null) {
            return;
        }
        Integer pid = m.getInt("parent_id");
        if (pid == 0) {
            return;
        }
        authPid.add(pid);
        Menu p = IndexController.getParent(menus, pid);
        this.findParent(authPid, menus, p);
    }
}

