/*
 * Decompiled with CFR 0.152.
 */
package com.eova.core.button;

import com.eova.common.Easy;
import com.eova.common.utils.db.DbUtil;
import com.eova.common.utils.xx;
import com.eova.config.EovaConst;
import com.eova.model.Button;
import com.eova.model.RoleBtn;
import com.jfinal.aop.Before;
import com.jfinal.core.Controller;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.NestedTransactionHelpException;
import com.jfinal.plugin.activerecord.tx.Tx;
import com.jfinal.plugin.activerecord.tx.TxConfig;
import java.util.List;

public class ButtonController
extends Controller {
    public void quick() {
        this.setAttr("menuCode", this.getPara(0));
        this.render("/eova/button/quick.html");
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void doQuick() {
        try {
            Button btn = new Button();
            String menuCode = this.getPara("menu_code");
            btn.set("menu_code", menuCode);
            Integer groupNum = this.getParaToInt("group_num", 0);
            btn.set("group_num", groupNum);
            btn.set("icon", this.getPara("icon"));
            btn.set("name", this.getPara("name"));
            btn.set("ui", this.getPara("ui"));
            btn.set("bs", xx.replaceBlank(this.getPara("bs")));
            btn.set("order_num", Button.dao.getMaxOrderNum(menuCode, groupNum) + 1);
            btn.save();
            String roles = this.getPara("role", EovaConst.ADMIN_RID + "");
            for (String role : roles.split(",")) {
                RoleBtn rb = new RoleBtn();
                rb.set("rid", role);
                rb.set("bid", btn.get("id"));
                rb.save();
            }
            this.renderJson(new Easy());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.renderJson(new Easy("\u65b0\u589e\u6309\u94ae\u5931\u8d25,\u8bf7\u770b\u63a7\u5236\u53f0\u65e5\u5fd7\u5bfb\u627e\u539f\u56e0\uff01"));
            throw new NestedTransactionHelpException("\u65b0\u589e\u6309\u94ae\u5931\u8d25");
        }
    }

    public void doExport() {
        String ids = this.getPara(0);
        StringBuilder sb = new StringBuilder();
        String sql = "select * from eova_button where id in (" + ids + ")";
        List objects = Db.use((String)"eova").find(sql);
        DbUtil.generateSql(objects, "eova_button", "id", sb);
        this.renderText(sb.toString());
    }
}

