/*
 * Decompiled with CFR 0.152.
 */
package com.eova.core.button;

import com.eova.common.utils.data.CloneUtil;
import com.eova.common.utils.xx;
import com.eova.config.EovaConst;
import com.eova.core.menu.config.MenuConfig;
import com.eova.model.Button;
import com.eova.model.Menu;
import com.eova.model.MetaObject;
import com.eova.model.RoleBtn;
import com.eova.template.Template;
import com.eova.template.diy.DiyTemplate;
import com.eova.template.masterslave.MasterSlaveTemplate;
import com.eova.template.office.OfficeTemplate;
import com.eova.template.single.SingleTemplate;
import com.eova.template.singlechart.SingleChartTemplate;
import com.eova.template.singletree.SingleTreeTemplate;
import com.eova.template.treetogrid.TreeToGridTemplate;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

public class ButtonFactory {
    private Template template;

    public ButtonFactory(String templateType) {
        if (templateType.equals("diy")) {
            this.template = new DiyTemplate();
        } else if (templateType.equals("single_grid")) {
            this.template = new SingleTemplate();
        } else if (templateType.equals("single_tree")) {
            this.template = new SingleTreeTemplate();
        } else if (templateType.equals("single_chart")) {
            this.template = new SingleChartTemplate();
        } else if (templateType.equals("master_slave_grid")) {
            this.template = new MasterSlaveTemplate();
        } else if (templateType.equals("tree_grid")) {
            this.template = new TreeToGridTemplate();
        } else if (templateType.equals("office")) {
            this.template = new OfficeTemplate();
        }
    }

    public void build(String menuCode, MenuConfig config) {
        Map<Integer, List<Button>> btnMap = this.template.getBtnMap();
        List<Button> btns = btnMap.get(0);
        for (int i = 0; i < btns.size(); ++i) {
            Button btn = btns.get(i);
            this.saveButton(btn, menuCode, 0, i);
        }
        btns = btnMap.get(1);
        if (this.template.code().equals("master_slave_grid")) {
            int groupNum = 1;
            for (String code : config.getObjects()) {
                MetaObject object = MetaObject.dao.getByCode(code);
                for (int i = 0; i < btns.size(); ++i) {
                    Button btn = CloneUtil.clone(btns.get(i));
                    btn.set("name", MessageFormat.format(btn.getStr("name"), object.getName()));
                    this.saveButton(btn, menuCode, groupNum, i);
                }
                ++groupNum;
            }
        }
    }

    private void saveButton(Button btn, String menuCode, int groupNum, int orderNum) {
        btn.set("menu_code", menuCode);
        btn.set("is_base", true);
        btn.set("group_num", groupNum);
        btn.set("order_num", orderNum);
        this.buildButtonUri(btn);
        btn.save();
        this.autoToAdmin(btn.getInt("id"));
    }

    private void autoToAdmin(int bid) {
        RoleBtn rf = new RoleBtn();
        rf.set("rid", EovaConst.ADMIN_RID);
        rf.set("bid", bid);
        rf.save();
    }

    private void buildButtonUri(Button button) {
        String uri;
        StringBuilder sb = new StringBuilder();
        int group = button.getInt("group_num");
        String ui = button.getStr("ui");
        String menuCode = button.getStr("menu_code");
        Menu menu = Menu.dao.findByCode(menuCode);
        String type = menu.getStr("type");
        List<String> objects = menu.getConfig().getObjects();
        String objectCode = menu.getConfig().getObjectCode();
        if (group > 0) {
            objectCode = objects.get(group - 1);
        }
        if (ui.equals("query")) {
            if ("diy".equals(type)) {
                String url = menu.getStr("url");
                if (!xx.isEmpty(url) && url.startsWith("/")) {
                    sb.append(String.format("%s/**", url)).append(";");
                }
            } else {
                sb.append(String.format("/%s/list/%s", type, menuCode)).append(";");
            }
            if (!"diy".equals(type) && !"office".equals(type)) {
                sb.append(String.format("/grid/query/%s*", objectCode)).append(";");
                sb.append(String.format("/grid/export/%s*", objectCode)).append(";");
            }
            if ("master_slave_grid".equals(type)) {
                for (String o : objects) {
                    sb.append(String.format("/grid/query/%s*", o)).append(";");
                    sb.append(String.format("/grid/export/%s*", o)).append(";");
                }
            }
            if ("single_tree".equals(type)) {
                sb.append(String.format("/treegrid/query/%s*", "")).append(";");
            }
            if ("tree_grid".equals(type)) {
                String objectCodeTree = menu.getConfig().getTree().getObjectCode();
                sb.append(String.format("/tree/query/%s*", objectCodeTree)).append(";");
            }
            if ("office".equals(type)) {
                sb.append(String.format("/office/show/%s", menuCode)).append(";");
                sb.append(String.format("/office/file/%s", menuCode)).append(";");
            }
        } else if (ui.endsWith("add.html")) {
            sb.append(String.format("/form/add/%s*", objectCode)).append(";");
            sb.append(String.format("/form/doAdd/%s", objectCode)).append(";");
        } else if (ui.endsWith("update.html")) {
            sb.append(String.format("/form/update/%s*", objectCode)).append(";");
            sb.append(String.format("/form/doUpdate/%s", objectCode)).append(";");
        } else if (ui.endsWith("detail.html")) {
            sb.append(String.format("/form/detail/%s*", objectCode)).append(";");
        } else if (ui.endsWith("delete.html")) {
            sb.append(String.format("/grid/delete/%s", objectCode)).append(";");
        } else if (ui.endsWith("hide.html")) {
            sb.append(String.format("/grid/hide/%s", objectCode)).append(";");
        } else if (ui.endsWith("import.html")) {
            sb.append(String.format("/single_grid/importXls/%s", menuCode)).append(";");
            sb.append(String.format("/single_grid/doImportXls/%s", menuCode)).append(";");
        }
        if (!xx.isEmpty(uri = sb.toString())) {
            uri = xx.delEnd(uri, ";");
            button.set("bs", uri);
        }
    }
}

