/*
 * Decompiled with CFR 0.152.
 */
package com.eova.core.menu;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eova.cloud.EovaCloud;
import com.eova.common.Easy;
import com.eova.common.base.BaseCache;
import com.eova.common.base.BaseController;
import com.eova.common.utils.db.DbUtil;
import com.eova.common.utils.xx;
import com.eova.config.EovaConfig;
import com.eova.config.EovaConst;
import com.eova.core.button.ButtonFactory;
import com.eova.core.menu.config.ChartConfig;
import com.eova.core.menu.config.MenuConfig;
import com.eova.core.menu.config.TreeConfig;
import com.eova.model.Button;
import com.eova.model.Menu;
import com.eova.model.MetaField;
import com.eova.model.MetaObject;
import com.eova.model.RoleBtn;
import com.jfinal.aop.Before;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.NestedTransactionHelpException;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.tx.Tx;
import com.jfinal.plugin.activerecord.tx.TxConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class MenuController
extends BaseController {
    public void toAdd() {
        this.keepPara(new String[]{"parent_id"});
        this.render("/eova/menu/form.html");
    }

    public void toUpdate() {
        int pkValue = this.getParaToInt(1);
        Menu menu = (Menu)Menu.dao.findById(pkValue);
        this.setAttr("menu", (Object)menu);
        this.render("/eova/menu/form.html");
    }

    public void toMenuFun() {
        String menuCode = this.getPara(0);
        Menu menu = Menu.dao.findByCode(menuCode);
        this.setAttr("menu", (Object)menu);
        HashMap<Integer, ArrayList<Button>> btnMap = new HashMap<Integer, ArrayList<Button>>();
        List<Button> btns = Button.dao.findNoQueryByMenuCode(menuCode);
        for (Button b : btns) {
            int group = b.getInt("group_num");
            ArrayList<Button> list = (ArrayList<Button>)btnMap.get(group);
            if (list == null) {
                list = new ArrayList<Button>();
                btnMap.put(group, list);
            }
            list.add(b);
        }
        this.setAttr("btnMap", btnMap);
        this.render("/eova/menu/menuFun.html");
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void addAll() {
        if (!this.getPara(0, "").equals("eova")) {
            this.renderJson(new Easy("\u8bf7\u8f93\u5165\u6821\u9a8c\u7801\uff0c\u9632\u6b62\u8bef\u64cd\u4f5c\uff01\uff01\uff01\uff01\uff01"));
            return;
        }
        List objects = MetaObject.dao.find("select * from eova_object where id >= 1100");
        for (MetaObject o : objects) {
            String menuCode = o.getStr("code");
            System.out.println("create " + menuCode);
            Menu menu = new Menu();
            menu.set("parent_id", 3);
            menu.set("name", o.getStr("name"));
            menu.set("code", menuCode);
            menu.set("type", "single_grid");
            MenuConfig config = new MenuConfig();
            config.setObjectCode(o.getStr("code"));
            menu.setConfig(config);
            menu.save();
            new ButtonFactory("single_grid").build(menuCode, config);
            o.set("diy_card", null);
            o.update();
        }
        BaseCache.delSer("all_menu");
        this.renderJson(new Easy("Auto Create Menu:" + objects.size(), true));
    }

    public void doExport() {
        String ids = this.getPara(0);
        StringBuilder sb = new StringBuilder();
        String sql = "select * from eova_menu where id in (" + ids + ")";
        List objects = Db.use((String)"eova").find(sql);
        DbUtil.generateSql(objects, "eova_menu", "id", sb);
        sb.append("\n");
        for (Record r : objects) {
            List btns = Db.use((String)"eova").find("select * from eova_button where menu_code = ?", new Object[]{r.getStr("code")});
            DbUtil.generateSql(btns, "eova_button", "id", sb);
            sb.append("\n");
        }
        this.renderText(sb.toString());
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void add() {
        String menuCode = this.getPara("code");
        String type = this.getPara("type");
        String sql = "select * from eova_menu where code = ?";
        Menu temp = (Menu)Menu.dao.findFirst(sql, new Object[]{menuCode});
        if (temp != null) {
            this.renderJson(new Easy("\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
            return;
        }
        String icon = this.getPara("iconField");
        if (!xx.isEmpty(icon) && icon.equalsIgnoreCase("icon")) {
            this.renderJson(new Easy("Tree\u56fe\u6807\u5b57\u6bb5:\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3aicon(\u7cfb\u7edf\u5173\u952e\u5b57\uff0c\u4f60\u53ef\u4ee5\u6539\u4e3a\uff1aiconskip)"));
            return;
        }
        icon = this.getPara("treeGridIconField");
        if (!xx.isEmpty(icon) && icon.equalsIgnoreCase("icon")) {
            this.renderJson(new Easy("Tree\u56fe\u6807\u5b57\u6bb5:\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3aicon(\u7cfb\u7edf\u5173\u952e\u5b57\uff0c\u4f60\u53ef\u4ee5\u6539\u4e3a\uff1aiconskip)"));
            return;
        }
        try {
            Menu menu = new Menu();
            menu.set("parent_id", this.getPara("parent_id"));
            menu.set("iconskip", this.getPara("icon", ""));
            menu.set("name", this.getPara("name"));
            menu.set("code", menuCode);
            menu.set("order_num", this.getPara("indexNum"));
            menu.set("type", type);
            String url = this.getPara("url", "");
            String path = this.getPara("path", "");
            menu.set("url", type.equals("diy") ? url : path);
            MenuConfig config = new MenuConfig();
            this.buildConfig(type, config);
            menu.setConfig(config);
            menu.save();
            if (type.equals("dir")) {
                this.renderJson(new Easy());
                return;
            }
            new ButtonFactory(type).build(menuCode, config);
            BaseCache.delSer("all_menu");
            EovaCloud.app();
            this.renderJson(new Easy());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.renderJson(new Easy("\u65b0\u589e\u83dc\u5355\u5931\u8d25,\u8bf7\u4ed4\u7ec6\u67e5\u770b\u63a7\u5236\u53f0\u65e5\u5fd7\uff01"));
            throw new NestedTransactionHelpException("\u65b0\u589e\u83dc\u5355\u5f02\u5e38");
        }
    }

    private void buildConfig(String type, MenuConfig config) {
        if (type.equals("single_grid")) {
            config.setObjectCode(this.getPara("objectCode"));
        } else if (type.equals("single_tree")) {
            config.setObjectCode(this.getPara("singleTreeObjectCode"));
            TreeConfig tc = new TreeConfig();
            tc.setIconField(this.getPara("iconField"));
            tc.setTreeField(this.getPara("treeField"));
            tc.setParentField(this.getPara("parentField"));
            tc.setIdField(this.getPara("idField", "id"));
            tc.setRootPid(this.getPara("rootPid"));
            config.setTree(tc);
        } else if (type.equals("single_chart")) {
            config.setObjectCode(this.getPara("singleChartObjectCode"));
            String ys = this.getPara("singleChartY");
            List<String> ens = Arrays.asList(ys.split(","));
            ArrayList<String> ycn = new ArrayList<String>();
            List<MetaField> fields = MetaField.dao.queryFields(config.getObjectCode());
            block0: for (String en : ens) {
                for (MetaField f : fields) {
                    if (!f.getEn().equals(en)) continue;
                    ycn.add(f.getCn());
                    continue block0;
                }
            }
            ChartConfig cc = new ChartConfig();
            cc.setType(this.getParaToInt("singleChartType"));
            cc.setX(this.getPara("singleChartX"));
            cc.setYunit(this.getPara("singleChartYunit"));
            cc.setY(ens);
            cc.setYcn(ycn);
            config.setChart(cc);
        } else if (type.equals("master_slave_grid")) {
            String masterObjectCode = this.getPara("masterObjectCode");
            String masterFieldCode = this.getPara("masterFieldCode");
            config.setObjectCode(masterObjectCode);
            config.setObjectField(masterFieldCode);
            ArrayList<String> objects = new ArrayList<String>();
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 1; i <= 5; ++i) {
                String slaveObjectCode = this.getPara("slaveObjectCode" + i);
                String slaveFieldCode = this.getPara("slaveFieldCode" + i);
                if (xx.isOneEmpty(slaveObjectCode, slaveFieldCode)) break;
                objects.add(slaveObjectCode);
                fields.add(slaveFieldCode);
            }
            config.setObjects(objects);
            config.setFields(fields);
        } else if (type.equals("tree_grid")) {
            TreeConfig tc = new TreeConfig();
            tc.setObjectCode(this.getPara("treeGridTreeObjectCode"));
            tc.setObjectField(this.getPara("treeGridTreeFieldCode"));
            tc.setIconField(this.getPara("treeGridIconField"));
            tc.setTreeField(this.getPara("treeGridTreeField"));
            tc.setParentField(this.getPara("treeGridParentField"));
            tc.setIdField(this.getPara("treeGridIdField", "id"));
            tc.setRootPid(this.getPara("treeGridRootPid"));
            config.setTree(tc);
            config.setObjectCode(this.getPara("treeGridObjectCode"));
            config.setObjectField(this.getPara("treeGridFieldCode"));
        } else if (type.equals("office")) {
            config.getParams().put("office_type", (Object)this.getPara("office_type"));
        }
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void menuFun() {
        String menuCode = this.getPara(0);
        List<Button> btns = Button.dao.findFunByMenuCode(menuCode);
        for (Button btn : btns) {
            Integer groupNum = btn.getInt("group_num");
            Integer id = btn.getInt("id");
            boolean isDel = this.getParaToBoolean(groupNum + "_" + id, true);
            if (btn.getBoolean("is_hide") == isDel) continue;
            btn.set("is_hide", isDel);
            btn.update();
        }
        this.renderJson(new Easy());
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void v16ButtonUpdate() {
        boolean isUpgrade = xx.getConfigBool("isUpgrade", false);
        if (!isUpgrade) {
            this.renderText("\u672a\u5f00\u542f\u5347\u7ea7\u6a21\u5f0f\uff0c\u8bf7\u542f\u52a8\u914d\u7f6e isUpgrade = true");
            return;
        }
        String sql = "select distinct(menu_code) from eova_button";
        List codes = Db.use((String)"eova").query(sql);
        int num = Db.use((String)"eova").update("update eova_button set is_base = 1 where ui = 'query'");
        System.err.println("\u4fee\u590d\u5f02\u5e38\u7684\u6309\u94ae\u6570=" + num);
        num = Db.use((String)"eova").update("delete from eova_button where is_base = 1 or ui = 'query'");
        System.err.println("\u5220\u9664\u6309\u94ae\u6570=" + num);
        for (String code : codes) {
            Menu menu = Menu.dao.findByCode(code);
            if (menu.getStr("type").equals("dir")) continue;
            new ButtonFactory(menu.getStr("type")).build(code, menu.getConfig());
        }
        num = Db.use((String)"eova").update("delete from eova_role_btn");
        System.err.println("\u6743\u9650\u6570\u636e\u88ab\u6e05\u7a7a");
        sql = "select id from eova_button where menu_code = ?";
        List ids = Db.use((String)"eova").query(sql, new Object[]{"sys_auth_role"});
        for (Integer id : ids) {
            RoleBtn rb = new RoleBtn();
            rb.set("bid", id);
            rb.set("rid", EovaConst.ADMIN_RID);
            rb.save();
        }
        this.initNewMenu();
        this.initEovaButton();
        this.renderText(" V1.4/1.5 -> V1.6 \u5347\u7ea7\u6210\u529f,\u8bf7\u91cd\u65b0\u5bf9\u6240\u6709\u89d2\u8272\u91cd\u65b0\u8fdb\u884c\u6743\u9650\u5206\u914d\uff01");
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void initNewMenu() {
        String isUpgrade = EovaConfig.getProps().get("isUpgrade");
        if (xx.isEmpty(isUpgrade) || !isUpgrade.equals("true")) {
            this.renderText("\u672a\u5f00\u542f\u5347\u7ea7\u6a21\u5f0f\uff0c\u8bf7\u542f\u52a8\u914d\u7f6e eova.config isUpgrade = true");
            return;
        }
        String sql = "select code from eova_menu where type not in ('dir') and code not in (select DISTINCT(menu_code) from eova_button);";
        List codes = Db.use((String)"eova").query(sql);
        for (String code : codes) {
            System.out.println(code);
            Menu menu = Menu.dao.findByCode(code);
            new ButtonFactory(menu.getStr("type")).build(code, menu.getConfig());
        }
        System.err.println("\u81ea\u52a8\u4fee\u590d\u672a\u751f\u6210\u6309\u94ae\u7684\u83dc\u5355\u6210\u529f");
        this.renderText("\u81ea\u52a8\u4e3a\u6ca1\u6709\u6309\u94ae\u7684\u83dc\u5355\u521d\u59cb\u5316\u6210\u529f\uff01");
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void initMenuButton() {
        JSONArray selectRows = this.getSelectRows();
        for (int i = 0; i < selectRows.size(); ++i) {
            JSONObject o = selectRows.getJSONObject(i);
            String menuCode = o.getString("code");
            Db.use((String)"eova").update("delete from eova_button where is_base = 1 and menu_code = ?", new Object[]{menuCode});
            Menu menu = Menu.dao.findByCode(menuCode);
            new ButtonFactory(menu.getStr("type")).build(menuCode, menu.getConfig());
            System.err.println("\u521d\u59cb\u5316\u83dc\u5355\u6309\u94ae\u6210\u529f\uff1a" + menuCode);
        }
        this.renderJson(new Easy());
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void initEovaButton() {
        String isUpgrade = EovaConfig.getProps().get("isUpgrade");
        if (xx.isEmpty(isUpgrade) || !isUpgrade.equals("true")) {
            this.renderText("\u672a\u5f00\u542f\u5347\u7ea7\u6a21\u5f0f\uff0c\u8bf7\u542f\u52a8\u914d\u7f6e eova.config isUpgrade = true");
            return;
        }
        String sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"eova_menu", "\u65b0\u589e"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"eova_menu", "\u67e5\u770b"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"eova_task", "\u5bfc\u5165"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"eova_object", "\u65b0\u589e"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"eova_object", "\u67e5\u770b"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"eova_object", "\u65b0\u589e"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"sys_auth_users", "\u67e5\u770b"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"sys_auth_users", "\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u65b0\u589e"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"sys_auth_users", "\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5220\u9664"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"sys_auth_role", "\u67e5\u770b"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and name = ?";
        Db.use((String)"eova").update(sql, new Object[]{"sys_auth_role", "\u5bfc\u5165"});
        sql = "UPDATE eova_button SET is_hide = 1 WHERE menu_code = ? and ui <> 'query'";
        Db.use((String)"eova").update(sql, new Object[]{"sys_log"});
        System.err.println("\u521d\u59cb\u5316EOVA\u6309\u94ae\u4fe1\u606f\u6210\u529f\uff01");
        this.renderText("\u521d\u59cb\u5316EOVA\u6309\u94ae\u4fe1\u606f\u6210\u529f\uff01");
    }
}

