/*
 * Decompiled with CFR 0.152.
 */
package com.eova.core.meta;

import com.alibaba.fastjson.JSONObject;
import com.eova.common.utils.xx;
import com.eova.config.EovaConfig;
import com.jfinal.kit.LogKit;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;

public class ColumnMeta {
    public String ds;
    public String table;
    public int position;
    public String name;
    public int dataType;
    public String dataTypeName;
    public int dataSize;
    public int dataDecimal;
    public boolean isNull;
    public boolean isAuto;
    public String defaultValue;
    public String remarks;

    public ColumnMeta(String ds, String table, JSONObject o) {
        this.ds = ds;
        this.table = table;
        this.position = o.getIntValue("ORDINAL_POSITION");
        this.name = o.getString("COLUMN_NAME");
        this.dataType = o.getIntValue("DATA_TYPE");
        this.dataTypeName = o.getString("TYPE_NAME");
        this.dataSize = o.getIntValue("COLUMN_SIZE");
        this.dataDecimal = o.getIntValue("DECIMAL_DIGITS");
        this.isNull = "YES".equalsIgnoreCase(o.getString("IS_NULLABLE"));
        this.isAuto = "YES".equalsIgnoreCase(o.getString("IS_AUTOINCREMENT"));
        this.defaultValue = o.getString("COLUMN_DEF");
        this.remarks = o.getString("REMARKS");
        this.buildRemarks();
    }

    public void buildRemarks() {
        if (xx.isOneEmpty(this.ds, this.table, this.remarks)) {
            return;
        }
        String[] ss = null;
        try {
            String ss1;
            if (this.remarks.contains(":") || this.remarks.contains("\uff1a")) {
                ss = this.remarks.split(":|\uff1a");
            }
            if (xx.isEmpty(ss)) {
                return;
            }
            this.remarks = ss[0];
            if (ss.length > 1 && (ss1 = ss[1]).contains("=")) {
                LogKit.info((String)String.format("\u81ea\u52a8\u751f\u6210\u5b57\u5178[%s - %s]", this.table, this.name));
                String[] dicts = ss1.split(",|\uff0c");
                String dictTable = EovaConfig.getProps().get("main_dict_table");
                Db.use((String)this.ds).update(String.format("delete from %s where object = ? and field = ?", dictTable), new Object[]{this.table, this.name});
                for (String dict : dicts) {
                    String[] sss = dict.split("=");
                    String value = sss[0];
                    String key = sss[1];
                    Record r = new Record();
                    r.set("value", (Object)value);
                    r.set("name", (Object)key);
                    r.set("object", (Object)this.table);
                    r.set("field", (Object)this.name);
                    r.set("ext", (Object)"");
                    Db.use((String)this.ds).save(dictTable, r);
                }
            }
        }
        catch (Exception e) {
            LogKit.error((String)("\u5143\u5b57\u6bb5\u5907\u6ce8\u9884\u5904\u7406\u5f02\u5e38:" + this.remarks), (Throwable)e);
        }
    }
}

