/*
 * Decompiled with CFR 0.152.
 */
package com.eova.core.meta;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eova.cloud.EovaCloud;
import com.eova.common.Easy;
import com.eova.common.base.BaseController;
import com.eova.common.utils.db.DbUtil;
import com.eova.common.utils.db.DsUtil;
import com.eova.common.utils.xx;
import com.eova.config.EovaConfig;
import com.eova.core.meta.ColumnMeta;
import com.eova.engine.EovaExp;
import com.eova.model.MetaField;
import com.eova.model.MetaObject;
import com.eova.model.User;
import com.jfinal.aop.Before;
import com.jfinal.kit.JsonKit;
import com.jfinal.kit.LogKit;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.tx.Tx;
import com.jfinal.plugin.activerecord.tx.TxConfig;
import java.util.ArrayList;
import java.util.List;

public class MetaController
extends BaseController {
    public void object() {
        String code = this.getPara(0);
        MetaObject mo = MetaObject.dao.getByCode(code);
        mo.remove("filter");
        mo.remove("table_name");
        mo.remove("view_name");
        mo.remove("view_sql");
        this.renderJson(JsonKit.toJson((Object)((Object)mo)));
    }

    public void fields() {
        String code = this.getPara(0);
        User user = (User)((Object)this.getSessionAttr("user"));
        List<MetaField> fields = MetaField.dao.queryFields(code, user);
        for (MetaField f : fields) {
            f.remove("exp");
            f.remove("table_name");
            f.remove("data_type");
            f.remove("data_type_name");
            f.remove("data_size");
            f.remove("data_decimal");
        }
        this.renderJson(JsonKit.toJson(fields));
    }

    public void edit() {
        String objectCode = this.getPara(0);
        this.setAttr("objectCode", objectCode);
        this.render("/eova/meta/edit.html");
    }

    public void imports() {
        this.setAttr("dataSources", EovaConfig.getDataSources());
        this.render("/eova/meta/import.html");
    }

    public void find() {
        String ds = this.getPara(0);
        String type = this.getPara(1);
        MetaObject eo = MetaObject.dao.getTemplate();
        eo.put("data_source", ds);
        eo.put("pk_name", "table_name");
        eo.put("cn", "table_name");
        ArrayList<MetaField> eis = new ArrayList<MetaField>();
        eis.add(EovaExp.buildItem(1, "table_name", "\u7f16\u7801", false));
        eis.add(EovaExp.buildItem(2, "table_name", "\u8868\u540d", true));
        this.setAttr("objectJson", JsonKit.toJson((Object)((Object)eo)));
        this.setAttr("fieldsJson", JsonKit.toJson(eis));
        this.setAttr("itemList", eis);
        this.setAttr("pk", "pk_name");
        this.setAttr("action", "/meta/findJson/" + ds + '-' + type);
        this.setAttr("isPaging", false);
        this.render("/eova/widget/find/find.html");
    }

    public void findJson() {
        String tableNamePattern;
        String ds = this.getPara(0);
        String type = this.getPara(1);
        String schemaPattern = null;
        if (xx.isOracle()) {
            schemaPattern = DsUtil.getUserNameByConfigName(ds);
        }
        if (!xx.isEmpty(tableNamePattern = this.getPara("query_table_name"))) {
            tableNamePattern = "%" + tableNamePattern + "%";
        }
        List<String> tables = DsUtil.getTableNamesByConfigName(ds, type, schemaPattern, tableNamePattern);
        JSONArray tableArray = new JSONArray();
        for (String tableName : tables) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("table_name", (Object)tableName);
            tableArray.add((Object)jsonObject);
        }
        String json = JsonKit.toJson((Object)tableArray);
        json = "{\"total\":" + tableArray.size() + ",\"rows\":" + json + "}";
        this.renderJson(json);
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void importAll() {
        if (!this.getPara(0, "").equals("eova")) {
            this.renderJson(new Easy("\u8bf7\u8f93\u5165\u6821\u9a8c\u7801\uff0c\u9632\u6b62\u8bef\u64cd\u4f5c\uff01\uff01\uff01\uff01\uff01"));
            return;
        }
        boolean isUpgrade = xx.getConfigBool("isUpgrade", false);
        if (!isUpgrade) {
            this.renderText("\u672a\u5f00\u542f\u5347\u7ea7\u6a21\u5f0f\uff0c\u8bf7\u542f\u52a8\u914d\u7f6e isUpgrade = true");
            return;
        }
        String ds = "main";
        String type = "Table";
        String db = DsUtil.getDbNameByConfigName(ds);
        List<String> tables = DsUtil.getTableNamesByConfigName(ds, type, null, null);
        for (String table : tables) {
            String msg;
            String s;
            if (table.startsWith("eova_") || table.equals("dicts") || table.equals("user_info")) continue;
            System.out.println(table);
            String name = table;
            String code = db + "_" + table;
            if (xx.isMysql() && !xx.isEmpty(s = Db.queryStr((String)"select TABLE_COMMENT FROM information_schema.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?", (Object[])new Object[]{db, table}))) {
                name = s;
            }
            if (xx.isEmpty(msg = this.importMeta(ds, type, table, name, code, "id"))) continue;
            LogKit.error((String)msg);
        }
        this.renderJson(new Easy());
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void doImports() {
        String ds = this.getPara("ds");
        String type = this.getPara("type");
        String table = this.getPara("table");
        String name = this.getPara("name");
        String code = this.getPara("code");
        String pk = this.getPara("pk");
        if (xx.isOneEmpty(ds, type, table, name, code)) {
            this.renderJson(new Easy("\u53c2\u6570\u90fd\u5fc5\u987b\u586b\u5199\uff01"));
            return;
        }
        MetaObject o = MetaObject.dao.getByCode(code);
        if (o != null) {
            this.renderJson(new Easy(String.format("\u5bf9\u8c61\u7f16\u7801[%s]\u5df2\u7ecf\u88ab\u5176\u5b83\u5bf9\u8c61\u4f7f\u7528\u4e86\uff0c\u8bf7\u4fee\u6539\u5bf9\u8c61\u7f16\u7801\uff01", code)));
            return;
        }
        String msg = this.importMeta(ds, type, table, name, code, pk);
        if (!xx.isEmpty(msg)) {
            this.renderJson(new Easy(msg));
            return;
        }
        this.renderJson(new Easy());
    }

    public void doExport() {
        String ids = this.getPara(0);
        StringBuilder sb = new StringBuilder();
        String sql1 = "select * from eova_object where id in (" + ids + ")";
        List objects = Db.use((String)"eova").find(sql1);
        DbUtil.generateSql(objects, "eova_object", "id", sb);
        sb.append("\n\n");
        String sql2 = "select * from eova_field where object_code in (select code from eova_object where id in (" + ids + "))";
        List fields = Db.use((String)"eova").find(sql2);
        DbUtil.generateSql(fields, "eova_field", "id", sb);
        this.renderText(sb.toString());
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void override() {
        String[] ids;
        String str = this.getPara(0);
        for (String id : ids = str.split(",")) {
            MetaObject o = (MetaObject)MetaObject.dao.findById(id);
            MetaObject.dao.deleteById(id);
            MetaField.dao.deleteByObjectCode(o.getCode());
            this.importMetaObject(o.getDs(), o.getType(), o.getView(), o.getName(), o.getCode(), o.getPk());
            this.importMetaField(o.getDs(), o.getView(), o.getCode());
        }
        this.renderJson(new Easy());
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void syncnew() {
        String[] ids;
        String code = this.getPara("objectCode");
        if (!xx.isEmpty(code)) {
            MetaObject mo = MetaObject.dao.getByCode(code);
            this.buildSyncNew(mo);
            this.renderJson(new Easy());
            return;
        }
        String str = this.getPara(0);
        for (String id : ids = str.split(",")) {
            MetaObject mo = (MetaObject)MetaObject.dao.findById(id);
            this.buildSyncNew(mo);
        }
        this.renderJson(new Easy());
    }

    private void buildSyncNew(MetaObject mo) {
        List<MetaField> fields = MetaField.dao.queryByObjectCode(mo.getCode());
        String ds = mo.getDs();
        String table = mo.getView();
        JSONArray list = DsUtil.getColumnInfoByConfigName(ds, table);
        for (int i = 0; i < list.size(); ++i) {
            JSONObject o = list.getJSONObject(i);
            String name = o.getString("COLUMN_NAME");
            boolean isNew = true;
            for (MetaField field : fields) {
                if (!name.equalsIgnoreCase(field.getEn())) continue;
                isNew = false;
            }
            if (!isNew) continue;
            ColumnMeta col = new ColumnMeta(ds, table, o);
            MetaField mi = new MetaField(mo.getCode(), col);
            mi.save();
            this.autoBindDict(table, mo.getCode(), o.getString("REMARKS"), mi.getEn());
        }
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void copy() {
        String id = this.getPara(0);
        String code = this.getPara(1);
        MetaObject object = (MetaObject)MetaObject.dao.findById(id);
        List<MetaField> fields = MetaField.dao.queryByObjectCode(object.getCode());
        for (MetaField f : fields) {
            f.remove("id");
            f.set("object_code", code);
            f.save();
        }
        object.remove("id");
        object.set("code", code);
        object.save();
        this.renderJson(new Easy());
    }

    public String importMeta(String ds, String type, String table, String name, String code, String pk) {
        if (type.equalsIgnoreCase("Table") && xx.isEmpty(pk = DsUtil.getPkName(ds, table))) {
            return "\u8868\u7684\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4e3a\u5f53\u524d\u8868\u8bbe\u7f6e\u4e3b\u952e\uff01";
        }
        this.importMetaField(ds, table, code);
        this.importMetaObject(ds, type, table, name, code, pk);
        EovaCloud.buildMeta(code);
        return null;
    }

    private void importMetaField(String ds, String table, String code) {
        JSONArray list = DsUtil.getColumnInfoByConfigName(ds, table);
        for (int i = 0; i < list.size(); ++i) {
            JSONObject o = list.getJSONObject(i);
            ColumnMeta col = new ColumnMeta(ds, table, o);
            MetaField mi = new MetaField(code, col);
            mi.save();
            this.autoBindDict(table, code, o.getString("REMARKS"), mi.getEn());
        }
    }

    private void autoBindDict(String tableName, String objectCode, String remarks, String fieldName) {
        if (xx.isEmpty(remarks)) {
            return;
        }
        if ((remarks.contains(":") || remarks.contains("\uff1a")) && remarks.contains("=")) {
            String dictTable = EovaConfig.getProps().get("main_dict_table");
            String exp = String.format("select value ID,name CN from %s where object = '%s' and field = '%s'", dictTable, tableName, fieldName);
            String sql = "update eova_field set type = '\u4e0b\u62c9\u6846', exp = ? where object_code = ? and en = ?";
            Db.use((String)"eova").update(sql, new Object[]{exp, objectCode, fieldName});
            LogKit.info((String)"\u81ea\u52a8\u7ed1\u5b9a\u5b57\u5178\u6210\u529f");
        }
    }

    private void importMetaObject(String ds, String type, String table, String name, String code, String pkName) {
        if (!xx.isEmpty(pkName)) {
            pkName = pkName.toLowerCase();
        }
        MetaObject mo = new MetaObject();
        mo.set("code", code);
        mo.set("name", name);
        mo.set("pk_name", pkName);
        mo.set("data_source", ds);
        if (type.equalsIgnoreCase("Table")) {
            mo.set("table_name", table.toLowerCase());
        } else {
            mo.set("view_name", table.toLowerCase());
            if (xx.isMysql()) {
                // empty if block
            }
        }
        mo.save();
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void syncField() {
        List os = MetaObject.dao.find("select * from eova_object");
        for (MetaObject o : os) {
            List<MetaField> fs = MetaField.dao.queryByObjectCode(o.getCode());
            String ds = o.getDs();
            String table = o.getView();
            JSONArray list = DsUtil.getColumnInfoByConfigName(ds, table);
            for (int i = 0; i < list.size(); ++i) {
                JSONObject json = list.getJSONObject(i);
                String name = json.getString("COLUMN_NAME");
                for (MetaField f : fs) {
                    if (!f.getEn().equalsIgnoreCase(name)) continue;
                    ColumnMeta col = new ColumnMeta(ds, table, json);
                    f.set("data_type", col.dataType);
                    f.set("data_type_name", col.dataTypeName);
                    f.set("data_size", col.dataSize);
                    f.set("data_decimal", col.dataDecimal);
                    f.set("is_auto", col.isAuto);
                    if (col.dataTypeName.contains("TIMESTAMP") && col.dataTypeName.contains("DATETIME")) {
                        f.set("type", "\u65f6\u95f4\u6846");
                    } else if (col.dataTypeName.contains("DATE")) {
                        f.set("type", "\u65e5\u671f\u6846");
                    }
                    f.update();
                }
            }
            LogKit.info((String)("\u5143\u6570\u636e\u5237\u65b0\u6210\u529f\uff1a" + o.getCode()));
        }
        this.renderJson(new Easy());
    }

    @Before(value={Tx.class})
    @TxConfig(value="eova")
    public void swap() {
        int sid = this.getParaToInt(0);
        int snum = this.getParaToInt(1);
        int tid = this.getParaToInt(2);
        int tnum = this.getParaToInt(3);
        if (snum - tnum == Math.abs(1)) {
            MetaField.dao.swapOrderNum(sid, tid, snum, tnum);
        } else {
            MetaField.dao.updateOrderNum(sid, tnum + 1);
        }
        this.renderJson(new Easy());
    }

    public void addVirtualField() {
        String en = this.getInputValue();
        String code = this.getPara("objectCode");
        if (xx.isEmpty(code)) {
            code = this.getSelectValue("code");
        }
        MetaField template = MetaField.dao.getTemplate();
        template.set("object_code", code);
        template.set("table_name", "virtual");
        template.set("en", "v_" + en);
        template.set("cn", en);
        template.set("order_num", 999);
        template.set("formatter", "function(value,row,index,field){return value}");
        template.save();
        this.renderJson(Easy.sucess("\u6dfb\u52a0\u865a\u62df\u5b57\u6bb5\u6210\u529f"));
    }
}

