/*
 * Decompiled with CFR 0.152.
 */
package com.eova.core.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MetaDataTest {
    private DatabaseMetaData dbMetaData = null;
    private Connection con = null;

    public MetaDataTest() {
        this.getDatabaseMetaData();
    }

    private void getDatabaseMetaData() {
        try {
            if (this.dbMetaData == null) {
                Class.forName("com.mysql.jdbc.Driver");
                String url = "jdbc:mysql://127.0.0.1:3306/chenzi";
                String user = "root";
                String password = "root";
                this.con = DriverManager.getConnection(url, user, password);
                this.dbMetaData = this.con.getMetaData();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getDataBaseInformations() {
        try {
            System.out.println("\u6570\u636e\u5e93\u5df2\u77e5\u7684\u7528\u6237: " + this.dbMetaData.getUserName());
            System.out.println("\u6570\u636e\u5e93\u7684\u7cfb\u7edf\u51fd\u6570\u7684\u9017\u53f7\u5206\u9694\u5217\u8868: " + this.dbMetaData.getSystemFunctions());
            System.out.println("\u6570\u636e\u5e93\u7684\u65f6\u95f4\u548c\u65e5\u671f\u51fd\u6570\u7684\u9017\u53f7\u5206\u9694\u5217\u8868: " + this.dbMetaData.getTimeDateFunctions());
            System.out.println("\u6570\u636e\u5e93\u7684\u5b57\u7b26\u4e32\u51fd\u6570\u7684\u9017\u53f7\u5206\u9694\u5217\u8868: " + this.dbMetaData.getStringFunctions());
            System.out.println("\u6570\u636e\u5e93\u4f9b\u5e94\u5546\u7528\u4e8e 'schema' \u7684\u9996\u9009\u672f\u8bed: " + this.dbMetaData.getSchemaTerm());
            System.out.println("\u6570\u636e\u5e93URL: " + this.dbMetaData.getURL());
            System.out.println("\u662f\u5426\u5141\u8bb8\u53ea\u8bfb:" + this.dbMetaData.isReadOnly());
            System.out.println("\u6570\u636e\u5e93\u7684\u4ea7\u54c1\u540d\u79f0:" + this.dbMetaData.getDatabaseProductName());
            System.out.println("\u6570\u636e\u5e93\u7684\u7248\u672c:" + this.dbMetaData.getDatabaseProductVersion());
            System.out.println("\u9a71\u52a8\u7a0b\u5e8f\u7684\u540d\u79f0:" + this.dbMetaData.getDriverName());
            System.out.println("\u9a71\u52a8\u7a0b\u5e8f\u7684\u7248\u672c:" + this.dbMetaData.getDriverVersion());
            System.out.println();
            System.out.println("\u6570\u636e\u5e93\u4e2d\u4f7f\u7528\u7684\u8868\u7c7b\u578b");
            ResultSet rs = this.dbMetaData.getTableTypes();
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
            rs.close();
            System.out.println(this.con.getCatalog());
            System.out.println();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getAllTableList(String schemaName) {
        try {
            String[] types = new String[]{"TABLE"};
            ResultSet rs = this.dbMetaData.getTables(null, schemaName, "%", types);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                String remarks = rs.getString("REMARKS");
                System.out.println(tableName + "-" + tableType + "-" + remarks);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getAllViewList(String schemaName) {
        try {
            String[] types = new String[]{"VIEW"};
            ResultSet rs = this.dbMetaData.getTables(null, schemaName, "%", types);
            while (rs.next()) {
                String viewName = rs.getString("TABLE_NAME");
                String viewType = rs.getString("TABLE_TYPE");
                String remarks = rs.getString("REMARKS");
                System.out.println(viewName + "-" + viewType + "-" + remarks);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getAllSchemas() {
        try {
            ResultSet rs = this.dbMetaData.getSchemas();
            while (rs.next()) {
                String tableSchem = rs.getString("TABLE_SCHEM");
                System.out.println(tableSchem);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getTableColumns(String schemaName, String tableName) {
        try {
            ResultSet rs = this.dbMetaData.getColumns(null, schemaName, tableName, "%");
            while (rs.next()) {
                String tableCat = rs.getString("TABLE_CAT");
                String tableSchemaName = rs.getString("TABLE_SCHEM");
                String tableName_ = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                int dataType = rs.getInt("DATA_TYPE");
                String dataTypeName = rs.getString("TYPE_NAME");
                int columnSize = rs.getInt("COLUMN_SIZE");
                int decimalDigits = rs.getInt("DECIMAL_DIGITS");
                int numPrecRadix = rs.getInt("NUM_PREC_RADIX");
                int nullAble = rs.getInt("NULLABLE");
                String remarks = rs.getString("REMARKS");
                String columnDef = rs.getString("COLUMN_DEF");
                int sqlDataType = rs.getInt("SQL_DATA_TYPE");
                int sqlDatetimeSub = rs.getInt("SQL_DATETIME_SUB");
                int charOctetLength = rs.getInt("CHAR_OCTET_LENGTH");
                int ordinalPosition = rs.getInt("ORDINAL_POSITION");
                String isNullAble = rs.getString("IS_NULLABLE");
                String isAutoincrement = rs.getString("IS_AUTOINCREMENT");
                System.out.println(tableCat + "-" + tableSchemaName + "-" + tableName_ + "-" + columnName + "-" + dataType + "-" + dataTypeName + "-" + columnSize + "-" + decimalDigits + "-" + numPrecRadix + "-" + nullAble + "-" + remarks + "-" + columnDef + "-" + sqlDataType + "-" + sqlDatetimeSub + charOctetLength + "-" + ordinalPosition + "-" + isNullAble + "-" + isAutoincrement + "-");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getIndexInfo(String schemaName, String tableName) {
        try {
            ResultSet rs = this.dbMetaData.getIndexInfo(null, schemaName, tableName, true, true);
            while (rs.next()) {
                boolean nonUnique = rs.getBoolean("NON_UNIQUE");
                String indexQualifier = rs.getString("INDEX_QUALIFIER");
                String indexName = rs.getString("INDEX_NAME");
                short type = rs.getShort("TYPE");
                short ordinalPosition = rs.getShort("ORDINAL_POSITION");
                String columnName = rs.getString("COLUMN_NAME");
                String ascOrDesc = rs.getString("ASC_OR_DESC");
                int cardinality = rs.getInt("CARDINALITY");
                System.out.println(nonUnique + "-" + indexQualifier + "-" + indexName + "-" + type + "-" + ordinalPosition + "-" + columnName + "-" + ascOrDesc + "-" + cardinality);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getAllPrimaryKeys(String schemaName, String tableName) {
        try {
            ResultSet rs = this.dbMetaData.getPrimaryKeys(null, schemaName, tableName);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                short keySeq = rs.getShort("KEY_SEQ");
                String pkName = rs.getString("PK_NAME");
                System.out.println(columnName + "-" + keySeq + "-" + pkName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getAllExportedKeys(String schemaName, String tableName) {
        try {
            ResultSet rs = this.dbMetaData.getExportedKeys(null, schemaName, tableName);
            while (rs.next()) {
                String pkTableCat = rs.getString("PKTABLE_CAT");
                String pkTableSchem = rs.getString("PKTABLE_SCHEM");
                String pkTableName = rs.getString("PKTABLE_NAME");
                String pkColumnName = rs.getString("PKCOLUMN_NAME");
                String fkTableCat = rs.getString("FKTABLE_CAT");
                String fkTableSchem = rs.getString("FKTABLE_SCHEM");
                String fkTableName = rs.getString("FKTABLE_NAME");
                String fkColumnName = rs.getString("FKCOLUMN_NAME");
                short keySeq = rs.getShort("KEY_SEQ");
                short updateRule = rs.getShort("UPDATE_RULE");
                short delRule = rs.getShort("DELETE_RULE");
                String fkName = rs.getString("FK_NAME");
                String pkName = rs.getString("PK_NAME");
                short deferRability = rs.getShort("DEFERRABILITY");
                System.out.println(pkTableCat + "-" + pkTableSchem + "-" + pkTableName + "-" + pkColumnName + "-" + fkTableCat + "-" + fkTableSchem + "-" + fkTableName + "-" + fkColumnName + "-" + keySeq + "-" + updateRule + "-" + delRule + "-" + fkName + "-" + pkName + "-" + deferRability);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void colseCon() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

