/*
 * Decompiled with CFR 0.152.
 */
package com.eova.core.meta;

import com.eova.common.utils.xx;
import com.eova.model.MetaField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class MetaDataType {
    private static final Map<String, Class> map = new HashMap<String, Class>(){
        {
            this.put("BIT", Boolean.class);
            this.put("TEXT", String.class);
            this.put("DATE", Date.class);
            this.put("DATETIME", DateTime.class);
            this.put("TIMESTAMP", Timestamp.class);
            this.put("TIME", Time.class);
            this.put("TINYINT", Integer.class);
            this.put("SMALLINT", Integer.class);
            this.put("MEDIUMINT", Integer.class);
            this.put("INT", Integer.class);
            this.put("BIGINT", Long.class);
            this.put("SMALLINT UNSIGNED", Integer.class);
            this.put("MEDIUMINT UNSIGNED", Integer.class);
            this.put("INT UNSIGNED", Integer.class);
            this.put("BIGINT UNSIGNED", BigInteger.class);
            this.put("FLOAT", Float.class);
            this.put("DOUBLE", Double.class);
            this.put("DECIMAL", BigDecimal.class);
            this.put("CHAR", String.class);
            this.put("VARCHAR", String.class);
            this.put("BINARY", Byte[].class);
            this.put("VARBINARY", Byte[].class);
            this.put("TINYBLOB", Byte[].class);
            this.put("VARCHAR", String.class);
            this.put("BLOB", Byte[].class);
            this.put("VARCHAR", String.class);
            this.put("MEDIUMBLOB", Byte[].class);
            this.put("VARCHAR", String.class);
            this.put("LONGBLOB", Byte[].class);
            this.put("VARCHAR", String.class);
            this.put("VARCHAR2", String.class);
            this.put("LONG", String.class);
            this.put("NUMBER", BigDecimal.class);
            this.put("CLOB", Clob.class);
        }
    };
    private static DateTimeFormatter forPattern = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");

    public static Class getType(String dataType) {
        return map.get(dataType);
    }

    public static Object convert(MetaField field, Object o) {
        if (o == null) {
            return null;
        }
        String typeName = field.getDataTypeName();
        Integer size = field.getInt("data_size");
        Integer decimal = field.getInt("data_decimal");
        Class clazz = MetaDataType.getType(typeName);
        if (xx.isMysql()) {
            if (typeName.equalsIgnoreCase("TINYINT") && size == 1) {
                clazz = Boolean.class;
            }
        } else if (xx.isOracle()) {
            if (typeName.equalsIgnoreCase("CHAR") && size == 1) {
                clazz = Boolean.class;
            } else if (typeName.equalsIgnoreCase("NUMBER")) {
                clazz = decimal == 0 ? (size <= 10 ? Integer.class : Long.class) : (size <= 4 ? Float.class : Double.class);
            }
        }
        o = MetaDataType.cast(o.toString(), clazz);
        return o;
    }

    public static Object cast(String s, Class c) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0 && c != String.class) {
            return null;
        }
        if (c == Integer.class) {
            return Integer.parseInt(s);
        }
        if (c == Long.class) {
            return Long.parseLong(s);
        }
        if (c == Float.class) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (c == Double.class) {
            return Double.parseDouble(s);
        }
        if (c == Boolean.class) {
            if (xx.isNum(s)) {
                s = s.equals("1") ? "true" : "false";
            }
            return Boolean.parseBoolean(s);
        }
        if (c == BigInteger.class) {
            return BigInteger.valueOf(Long.parseLong(s));
        }
        if (c == BigDecimal.class) {
            return BigDecimal.valueOf(Double.parseDouble(s));
        }
        if (c == Byte[].class) {
            return s.getBytes();
        }
        try {
            if (c == Timestamp.class) {
                long time = DateTime.parse((String)s, (DateTimeFormatter)forPattern).getMillis();
                return new Timestamp(time);
            }
            if (c == DateTime.class) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(s);
            }
            if (c == Date.class) {
                return new SimpleDateFormat("yyyy-MM-dd").parse(s);
            }
            if (c == Time.class) {
                return new SimpleDateFormat("HH:mm:ss").parse(s);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return s;
    }
}

