/*
 * Decompiled with CFR 0.152.
 */
package com.eova.engine;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.eova.common.utils.xx;
import com.eova.config.EovaConfig;
import com.eova.engine.SqlParse;
import com.eova.model.MetaField;
import com.eova.model.MetaObject;
import com.jfinal.kit.LogKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EovaExp {
    public String ds;
    public String sql;
    public String select;
    public String simpleSelect;
    public String from;
    public String table;
    public String where;
    public String order;
    public String pk;
    public String cn;
    private HashMap<String, String> param = new HashMap();
    protected SqlParse sp;

    public EovaExp() {
    }

    public EovaExp(String exp) {
        try {
            exp = exp.trim().toLowerCase();
            if (!exp.contains(";")) {
                this.sql = exp;
                this.ds = "main";
            } else {
                String[] strs = exp.split(";");
                this.sql = strs[0];
                this.ds = strs[1].substring(3);
                for (String s : strs) {
                    if ((s = s.trim()).startsWith("select")) continue;
                    String[] ss = s.split("=");
                    this.param.put(ss[0].trim(), ss[1].trim());
                }
            }
            this.sp = new SqlParse(EovaConfig.EOVA_DBTYPE, this.sql);
            this.initParse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        EovaExp.print("select id ID, pid PID, name CN, icon ICON from eova_menu");
    }

    private static void print(String exp) {
        EovaExp se = new EovaExp(exp);
        System.out.println(EovaExp.format(se.sql));
        System.out.println();
        System.out.println("DS:" + se.ds);
        System.out.println("SS:" + se.simpleSelect);
        System.out.println("SELECT:" + se.select);
        System.out.println("FROM:" + se.from);
        System.out.println("WHERE:" + se.where);
        System.out.println("ORDER:" + se.order);
        System.out.println("PK:" + se.pk);
        System.out.println("CN:" + se.cn);
        System.out.println();
        System.out.println();
    }

    public void initParse() {
        List<SQLSelectItem> items = this.sp.getSelectItem();
        try {
            this.pk = SqlParse.getExprName(items.get(0).getExpr());
            this.cn = SqlParse.getExprName(items.get(1).getExpr());
        }
        catch (Exception e) {
            LogKit.debug((String)("EovaExp initParse Select Item Error:" + this.sp.getSelectItem()));
        }
        this.buildSelect();
        this.buildSimpleSelect();
        this.buildFrom();
        this.buildTable();
        this.buildWhere();
        this.buildOrder();
    }

    private void buildSelect() {
        this.select = "select " + this.sp.getSelectItem().toString().replaceAll("\\[|\\]", "");
    }

    private void buildSimpleSelect() {
        StringBuilder sb = new StringBuilder("select ");
        for (SQLSelectItem item : this.sp.getSelectItem()) {
            sb.append(item.getExpr()).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        this.simpleSelect = sb.toString().trim();
    }

    private void buildFrom() {
        SQLTableSource ts = this.sp.query.getFrom();
        String alias = ts.getAlias();
        String s = " from " + ts.toString();
        if (alias != null) {
            s = s + ' ' + alias;
        }
        this.from = EovaExp.format(s);
    }

    private void buildTable() {
        this.table = this.from.toLowerCase().replace(" from ", "");
    }

    private void buildWhere() {
        SQLExpr exp = this.sp.query.getWhere();
        if (exp == null) {
            this.where = "";
            return;
        }
        String s = " where " + SQLUtils.toSQLString((SQLObject)exp);
        this.where = EovaExp.format(s);
    }

    private void buildOrder() {
        StringBuilder sb = new StringBuilder(" order by ");
        List<SQLSelectOrderByItem> items = this.sp.getOrderItem();
        if (items == null) {
            return;
        }
        for (SQLSelectOrderByItem x : items) {
            sb.append(SQLUtils.toSQLString((SQLObject)x));
            sb.append(',');
        }
        sb.delete(sb.length() - 1, sb.length());
        this.order = sb.toString();
    }

    private static String format(String str) {
        str = str.replaceAll("\t|\r|\n", " ");
        str = str.replaceAll("  ", " ");
        return str;
    }

    public MetaObject getObject() {
        MetaObject eo = MetaObject.dao.getTemplate();
        eo.put("data_source", this.ds);
        eo.put("name", "");
        eo.put("pk_name", this.pk);
        eo.put("cn", this.cn);
        return eo;
    }

    public List<MetaField> getFields() {
        try {
            ArrayList<MetaField> fields = new ArrayList<MetaField>();
            int index = 0;
            List<SQLSelectItem> items = this.sp.getSelectItem();
            for (SQLSelectItem item : items) {
                SQLIdentifierExpr expr = (SQLIdentifierExpr)item.getExpr();
                String en = expr.getName();
                String cn = item.getAlias();
                boolean isQuery = true;
                if (++index == 1) {
                    isQuery = false;
                }
                fields.add(EovaExp.buildItem(index, en, cn, isQuery));
            }
            return fields;
        }
        catch (Exception e) {
            LogKit.debug((String)("EovaExp initParse getFields Error:" + this.sp.getSelectItem()));
            return null;
        }
    }

    public static MetaField buildItem(int index, String en, String cn, boolean isQuery) {
        if (xx.isEmpty(cn)) {
            cn = en;
        }
        en = en.toLowerCase();
        MetaField ei = MetaField.dao.getTemplate();
        ei.put("order_num", index);
        ei.put("en", en);
        ei.put("cn", cn);
        ei.put("type", "\u6587\u672c\u6846");
        ei.put("is_query", isQuery);
        ei.put("width", 40 + cn.length() * 20);
        return ei;
    }

    public String getPara(String key, String defaultValue) {
        String val = this.param.get(key);
        if (xx.isEmpty(val)) {
            return defaultValue;
        }
        return val;
    }
}

