/*
 * Decompiled with CFR 0.152.
 */
package com.eova.engine;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.eova.engine.sql.TableSource;
import java.util.List;

public class SqlParse {
    private String dbType;
    public List<SQLStatement> stmtList;
    public SQLSelectStatement selectStatement;
    public SQLSelect sqlselect;
    public SQLSelectQueryBlock query;

    public SqlParse() {
    }

    public SqlParse(String dbType, String sql) {
        this.dbType = dbType;
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (String)dbType);
        this.stmtList = parser.parseStatementList();
        this.selectStatement = (SQLSelectStatement)this.stmtList.get(0);
        this.sqlselect = this.selectStatement.getSelect();
        this.query = (SQLSelectQueryBlock)this.sqlselect.getQuery();
    }

    public List<SQLSelectItem> getSelectItem() {
        return this.query.getSelectList();
    }

    public List<SQLSelectOrderByItem> getOrderItem() {
        if (this.dbType.equals("mysql")) {
            MySqlSelectQueryBlock block = (MySqlSelectQueryBlock)this.query;
            if (block.getOrderBy() == null) {
                return null;
            }
            return block.getOrderBy().getItems();
        }
        if (this.dbType.equals("oracle")) {
            if (this.sqlselect.getOrderBy() == null) {
                return null;
            }
            return this.sqlselect.getOrderBy().getItems();
        }
        if (this.dbType.equals("postgresql")) {
            PGSelectQueryBlock block = (PGSelectQueryBlock)this.query;
            if (block.getOrderBy() == null) {
                return null;
            }
            return block.getOrderBy().getItems();
        }
        if (this.sqlselect.getOrderBy() == null) {
            return null;
        }
        return this.sqlselect.getOrderBy().getItems();
    }

    public static String getExprName(SQLExpr expr) {
        if (expr instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)expr).getName();
        }
        if (expr instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)expr).getName();
        }
        return "";
    }

    public static String getExprAlias(SQLExpr expr) {
        return SqlParse.getExprOw((SQLExpr)((SQLPropertyExpr)expr));
    }

    public static String getExprOw(SQLExpr expr) {
        return SqlParse.getExprName(((SQLPropertyExpr)expr).getOwner());
    }

    public static void main(String[] args) {
        System.out.println("------------mysql");
        SqlParse.print("mysql");
        System.out.println("------------ORACLE");
        SqlParse.print("oracle");
        System.out.println("------------POSTGRESQL");
        SqlParse.print("postgresql");
        System.out.println("------------SQL_SERVER");
        SqlParse.print("sqlserver");
    }

    private static void print(String dbType) {
        SQLPropertyExpr exp;
        String sql = "select t1.a \u5475\u5475, t1.b , t2.c from t1 left join t2 where t1.id = t2.pid and a.id = 1 order by id,indexNum desc";
        SqlParse sp = new SqlParse(dbType, sql);
        System.out.println("select ");
        List<SQLSelectItem> items = sp.getSelectItem();
        for (SQLSelectItem s : items) {
            exp = (SQLPropertyExpr)s.getExpr();
            System.out.println(exp.getOwner().toString() + '.' + exp.getName() + ' ' + s.getAlias());
        }
        System.out.println(" form " + sp.query.getFrom().toString());
        System.out.println(" where " + sp.query.getWhere().toString());
        System.out.println("order by ");
        items = sp.getOrderItem();
        for (SQLSelectItem s : items) {
            exp = (SQLIdentifierExpr)s.getExpr();
            System.out.print(exp.getName() + ' ');
            if (s.getType() == null) continue;
            System.out.println(s.getType().name());
        }
        System.out.println();
    }

    public static void parseTableSource(SQLTableSource formTs, List<TableSource> sources) throws Exception {
        if (formTs instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)formTs;
            if (join.getCondition() == null) {
                throw new Exception("Eova\u5f53\u524d\u4ec5\u652f\u6301Left Join\u67e5\u8be2\u65b9\u5f0f\u7684View\u8fdb\u884c\u81ea\u52a8\u6301\u4e45\u5316\u64cd\u4f5c\uff0c\u8bf7\u624b\u5de5\u81ea\u5b9a\u4e49\u65b0\u589e\uff0c\u4fee\u6539\u7b49\u64cd\u4f5c\uff01");
            }
            SqlParse.parseTableSource(join.getLeft(), sources);
            SQLExprTableSource right = (SQLExprTableSource)join.getRight();
            SQLBinaryOpExpr condition = (SQLBinaryOpExpr)join.getCondition();
            String table = SqlParse.getExprName(right.getExpr());
            String alias = right.getAlias();
            TableSource source = SqlParse.buildTableSource(condition, table, alias);
            sources.add(source);
        } else {
            SQLExprTableSource join = (SQLExprTableSource)formTs;
            SQLJoinTableSource parent = (SQLJoinTableSource)join.getParent();
            SQLBinaryOpExpr condition = (SQLBinaryOpExpr)parent.getCondition();
            String table = SqlParse.getExprName(join.getExpr()).toString();
            String alias = join.getAlias();
            TableSource source = SqlParse.buildTableSource(condition, table, alias);
            sources.add(source);
        }
    }

    private static TableSource buildTableSource(SQLBinaryOpExpr condition, String table, String alias) {
        TableSource source = new TableSource();
        source.setTable(table);
        source.setAlias(alias);
        source.setLeftField(SqlParse.getExprName(condition.getLeft()));
        source.setLeftAlias(SqlParse.getExprOw(condition.getLeft()));
        source.setRigthField(SqlParse.getExprName(condition.getRight()));
        source.setRigthAlias(SqlParse.getExprOw(condition.getRight()));
        return source;
    }
}

