/*
 * Decompiled with CFR 0.152.
 */
package com.eova.engine.sql;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.eova.common.utils.db.DbUtil;
import com.eova.common.utils.db.DsUtil;
import com.eova.common.utils.xx;
import com.eova.core.object.config.TableConfig;
import com.eova.engine.SqlParse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewFactory {
    private final String ds;
    private final String sql;
    private final String dbType;
    private MySqlSchemaStatVisitor vt;

    public ViewFactory(String sql) {
        this("main", sql);
    }

    public ViewFactory(String ds, String sql) {
        this(ds, sql, "mysql");
    }

    public ViewFactory(String ds, String sql, String dbType) {
        this.ds = ds;
        this.sql = sql;
        this.dbType = dbType;
        this.init();
    }

    private void init() {
        System.out.println(this.sql);
        List stmtList = SQLUtils.parseStatements((String)this.sql, (String)this.dbType);
        if (stmtList.size() != 1) {
            throw new RuntimeException("View Sql \u89e3\u6790\u5f02\u5e38");
        }
        SQLStatement stmt = (SQLStatement)stmtList.get(0);
        this.vt = new MySqlSchemaStatVisitor();
        stmt.accept((SQLASTVisitor)this.vt);
    }

    public LinkedHashMap<String, TableConfig> parse() {
        Map tables = this.vt.getTables();
        Set tableNames = tables.keySet();
        Map aliasMap = this.vt.getAliasMap();
        System.out.println("Tables : " + tableNames);
        System.out.println("fields : " + this.vt.getColumns());
        ArrayList<String> selectItem = new ArrayList<String>();
        SqlParse sp = new SqlParse(this.dbType, this.sql);
        for (SQLSelectItem item : sp.getSelectItem()) {
            SQLPropertyExpr pe = (SQLPropertyExpr)item.getExpr();
            String name = pe.getName();
            String ow = pe.getOwner().toString();
            selectItem.add((String)aliasMap.get(ow) + '.' + name);
        }
        Set relationships = this.vt.getRelationships();
        System.out.println("Ref    : " + relationships);
        HashMap refs = new HashMap();
        for (TableStat.Relationship rs : relationships) {
            String left = rs.getLeft().toString();
            String right = rs.getRight().toString();
            Set<String> set = (HashSet<String>)refs.get(left);
            if (set == null) {
                set = new HashSet<String>();
            }
            set.add(right);
            refs.put(left, set);
            set = (Set)refs.get(right);
            if (set == null) {
                set = new HashSet();
            }
            set.add(left);
            refs.put(right, set);
            rs.getRight();
        }
        System.out.println("\u5173\u7cfb:" + refs);
        LinkedHashMap<String, TableConfig> config = new LinkedHashMap<String, TableConfig>();
        for (TableStat.Name n : tableNames) {
            String[] ss;
            String tableName = n.getName();
            System.out.println("table: " + tableName);
            TableConfig tc = new TableConfig();
            block5: for (Map.Entry entry : refs.entrySet()) {
                String key = (String)entry.getKey();
                Set refFields = (Set)entry.getValue();
                if (!DbUtil.compareTable(key, tableName)) continue;
                tc.setWhereField(DbUtil.getEndName(key));
                for (String field : refFields) {
                    if (selectItem.contains(field)) {
                        tc.setParamField(DbUtil.getEndName(field));
                        break block5;
                    }
                    String paramField = this.findRefField(selectItem, (Set)refs.get(field));
                    if (paramField == null) continue;
                    tc.setParamField(paramField);
                    break block5;
                }
            }
            if ((ss = tableName.split("\\.")).length == 2) {
                tableName = ss[1];
            }
            String pk = null;
            try {
                pk = DsUtil.getPkName(this.ds, tableName);
                System.out.println("PK:" + pk);
            }
            catch (Exception refFields) {
                // empty catch block
            }
            if (pk == null && DbUtil.compareTable(tableName, "orders")) {
                pk = "id";
            }
            if (!xx.isEmpty(pk)) {
                for (String i : selectItem) {
                    if (!DbUtil.compareField(i, tableName + "." + pk)) continue;
                    tc.setWhereField(pk);
                    tc.setParamField(pk);
                    break;
                }
            }
            config.put(tableName, tc);
        }
        return config;
    }

    public Collection<TableStat.Column> getColumns() {
        Collection columns = this.vt.getColumns();
        return columns;
    }

    private String findRefField(List<String> selectItem, Set<String> val) {
        for (String field : val) {
            if (!selectItem.contains(field)) continue;
            return DbUtil.getEndName(field);
        }
        return null;
    }

    public static void main(String[] args) {
        String sql = "SELECT `u`.`id` AS `id`, `u`.`status` AS `status`, `u`.`login_id` AS `login_id`, `u`.`login_pwd` AS `login_pwd`, `u`.`nickname` AS `nickname`, `u`.`reg_time` AS `reg_time`, `u`.`info` AS `info`, `u`.`tag` AS `tag`, `ue`.`exp` AS `exp`, `ue`.`avg` AS `avg`, `ue`.`qq` AS `qq` FROM ( `users` `u` JOIN `users_exp` `ue` ) WHERE (`u`.`id` = `ue`.`users_id`)";
        ViewFactory vf = new ViewFactory(sql);
        LinkedHashMap<String, TableConfig> parse = vf.parse();
        System.out.println(xx.formatJson(JSONObject.toJSONString(parse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SortField})));
        sql = "select `h`.`id` AS `id`,`h`.`name` AS `name`,`hb`.`num` AS `num`,`hs`.`category` AS `category` from ((`demo`.`hotel` `h` left join `demo`.`hotel_bed` `hb` on((`hb`.`hotel_id` = `h`.`id`))) left join `demo`.`hotel_stock` `hs` on((`hs`.`hotel_id` = `h`.`id`)))";
        vf = new ViewFactory(sql);
        parse = vf.parse();
        System.out.println(xx.formatJson(JSONObject.toJSONString(parse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SortField})));
        sql = "select `o`.`id` AS `id`,`o`.`state` AS `state`,`o`.`money` AS `money`,`o`.`memo` AS `memo`,`o`.`create_user_id` AS `create_user_id`,`o`.`create_time` AS `create_time`,`o`.`address_id` AS `address_id`,`a`.`name` AS `name`,`a`.`full` AS `full`,`a`.`mobilephone` AS `mobilephone`,`u`.`login_id` AS `login_id`,`u`.`nickname` AS `nickname`,`u`.`info` AS `info` from ((`demo`.`orders` `o` left join `demo`.`users` `u` on((`o`.`create_user_id` = `u`.`id`))) left join `demo`.`address` `a` on((`o`.`address_id` = `a`.`id`)))";
        vf = new ViewFactory(sql);
        parse = vf.parse();
        System.out.println(xx.formatJson(JSONObject.toJSONString(parse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SortField})));
    }
}

