/*
 * Decompiled with CFR 0.152.
 */
package com.eova.ext.jfinal;

import com.eova.common.utils.db.DbUtil;
import com.eova.common.utils.xx;
import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.ModelBuilder;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.RecordBuilder;
import com.jfinal.plugin.activerecord.dialect.OracleDialect;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EovaOracleDialect
extends OracleDialect {
    public <T> List<T> buildModelList(ResultSet rs, Class<? extends Model> modelClass) throws SQLException, InstantiationException, IllegalAccessException {
        ArrayList<Model> result = new ArrayList<Model>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        ModelBuilder.me.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Model ar = modelClass.newInstance();
            Map attrs = CPI.getAttrs((Model)ar);
            for (int i = 1; i <= columnCount; ++i) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? ModelBuilder.me.handleClob(rs.getClob(i)) : (types[i] == 2011 ? ModelBuilder.me.handleClob((Clob)rs.getNClob(i)) : (types[i] == 2004 ? (Object)ModelBuilder.me.handleBlob(rs.getBlob(i)) : rs.getObject(i))));
                if (value != null && xx.isOracle()) {
                    value = DbUtil.convertOracleValue(value, types[i]);
                }
                attrs.put(labelNames[i], value);
            }
            result.add(ar);
        }
        return result;
    }

    public List<Record> buildRecordList(Config config, ResultSet rs) throws SQLException {
        ArrayList<Record> result = new ArrayList<Record>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        RecordBuilder.me.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Record record = new Record();
            CPI.setColumnsMap((Record)record, (Map)config.getContainerFactory().getColumnsMap());
            Map columns = record.getColumns();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? ModelBuilder.me.handleClob(rs.getClob(i)) : (types[i] == 2011 ? ModelBuilder.me.handleClob((Clob)rs.getNClob(i)) : (types[i] == 2004 ? (Object)ModelBuilder.me.handleBlob(rs.getBlob(i)) : rs.getObject(i))));
                if (value != null && xx.isOracle()) {
                    value = DbUtil.convertOracleValue(value, types[i]);
                }
                columns.put(labelNames[i], value);
            }
            result.add(record);
        }
        return result;
    }
}

