/*
 * Decompiled with CFR 0.152.
 */
package com.eova.interceptor;

import com.eova.common.utils.util.AntPathMatcher;
import com.eova.common.utils.xx;
import com.eova.config.EovaConfig;
import com.eova.interceptor.LoginInterceptor;
import com.eova.model.User;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import java.util.Set;

public class AuthInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        AntPathMatcher pm = new AntPathMatcher();
        String uri = inv.getController().getRequest().getRequestURI();
        if (pm.match("/*", uri) || uri.endsWith("/toLogin")) {
            inv.invoke();
            return;
        }
        for (String pattern : LoginInterceptor.excludes) {
            if (!pm.match(pattern, uri)) continue;
            inv.invoke();
            return;
        }
        User user = (User)((Object)inv.getController().getSessionAttr("user"));
        if (user.isAdmin()) {
            inv.invoke();
            return;
        }
        String msg = "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c\uff1a" + uri;
        Set authUriPattern = (Set)user.get("auths");
        if (xx.isEmpty(authUriPattern)) {
            inv.getController().renderText(msg);
            return;
        }
        Set<String> temp = EovaConfig.getAuthUris().get(user.getRid());
        if (!xx.isEmpty(temp)) {
            authUriPattern.addAll(temp);
        }
        if (!xx.isEmpty(temp = EovaConfig.getAuthUris().get(0))) {
            authUriPattern.addAll(temp);
        }
        for (String pattern : authUriPattern) {
            if (!pm.match(pattern, uri)) continue;
            inv.invoke();
            return;
        }
        inv.getController().renderText(msg);
    }
}

