/*
 * Decompiled with CFR 0.152.
 */
package com.eova.model;

import com.alibaba.fastjson.JSON;
import com.eova.common.base.BaseModel;
import com.eova.common.utils.xx;
import com.eova.core.menu.config.MenuConfig;
import java.util.List;

public class Menu
extends BaseModel<Menu> {
    private static final long serialVersionUID = 7072369370299999169L;
    public static final String TYPE_DIR = "dir";
    public static final String TYPE_DIY = "diy";
    public static final Menu dao = new Menu();
    private List<Menu> childList;

    public List<Menu> getChildList() {
        return this.childList;
    }

    public void setChildList(List<Menu> childList) {
        this.childList = childList;
    }

    public String getBizIntercept() {
        return this.getStr("biz_intercept");
    }

    public MenuConfig getConfig() {
        String json = this.getStr("config");
        if (xx.isEmpty(json)) {
            return null;
        }
        return new MenuConfig(json);
    }

    public void setConfig(MenuConfig config) {
        this.set("config", JSON.toJSONString((Object)config));
    }

    public String getUrl() {
        String type = this.getStr("type");
        if (type.equals(TYPE_DIR)) {
            return "";
        }
        if (type.equals(TYPE_DIY)) {
            return this.getStr("url");
        }
        return '/' + type + "/list/" + this.getStr("code");
    }

    public Menu findByCode(String code) {
        if (code == null) {
            return null;
        }
        String sql = "select * from eova_menu where code = ?";
        return (Menu)((Object)dao.queryFisrtByCache(sql, code));
    }

    public List<Menu> queryRoot() {
        return super.queryByCache("select * from eova_menu where parent_id = 0 order by order_num");
    }

    public List<Menu> queryMenu() {
        String sql = "select id,parent_id,name,iconskip,open,code,type,url from eova_menu where is_hide = 0 order by parent_id,order_num";
        return super.queryByCache(sql);
    }

    public boolean isParent(int id) {
        String sql = "select count(*) from eova_menu where parent_id = ?";
        return dao.isExist(sql, id);
    }
}

