/*
 * Decompiled with CFR 0.152.
 */
package com.eova.model;

import com.alibaba.fastjson.JSON;
import com.eova.common.base.BaseModel;
import com.eova.common.utils.time.TimestampUtil;
import com.eova.common.utils.xx;
import com.eova.config.EovaConfig;
import com.eova.core.meta.ColumnMeta;
import com.eova.core.meta.MetaEngine;
import com.eova.engine.DynamicParse;
import com.eova.model.MetaFieldConfig;
import com.eova.model.User;
import com.jfinal.plugin.activerecord.Db;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class MetaField
extends BaseModel<MetaField> {
    private static final long serialVersionUID = -7381270435240459528L;
    public static final MetaField dao = new MetaField();
    public static final String TYPE_TEXT = "\u6587\u672c\u6846";
    public static final String TYPE_NUM = "\u6570\u5b57\u6846";
    public static final String TYPE_COMBO = "\u4e0b\u62c9\u6846";
    public static final String TYPE_COMBO_TREE = "\u4e0b\u62c9\u6811";
    public static final String TYPE_FIND = "\u67e5\u627e\u6846";
    public static final String TYPE_TIME = "\u65f6\u95f4\u6846";
    public static final String TYPE_DATE = "\u65e5\u671f\u6846";
    public static final String TYPE_TEXTS = "\u6587\u672c\u57df";
    public static final String TYPE_EDIT = "\u7f16\u8f91\u6846";
    public static final String TYPE_BOOL = "\u5e03\u5c14\u6846";
    public static final String TYPE_AUTO = "\u81ea\u589e\u6846";
    public static final String TYPE_IMG = "\u56fe\u7247\u6846";
    public static final String TYPE_FILE = "\u6587\u4ef6\u6846";
    public static final String DATATYPE_STRING = "string";
    public static final String DATATYPE_NUMBER = "number";
    public static final String DATATYPE_TIME = "time";

    public MetaField() {
    }

    public MetaField(String objectCode, ColumnMeta col) {
        String defaulter;
        if (EovaConfig.isLowerCase) {
            col.name = col.name.toLowerCase();
        }
        this.set("object_code", objectCode);
        this.set("en", col.name);
        this.set("cn", col.remarks);
        this.set("order_num", col.position * 10);
        this.set("is_required", !col.isNull);
        this.set("data_type", col.dataType);
        this.set("data_type_name", col.dataTypeName);
        this.set("data_size", col.dataSize);
        this.set("data_decimal", col.dataDecimal);
        this.set("defaulter", col.defaultValue);
        this.set("is_auto", col.isAuto);
        this.set("type", MetaField.getFormType(col));
        if (col.isAuto) {
            this.set("add_status", 50);
            this.set("update_status", 20);
        }
        if (xx.isEmpty(this.getCn())) {
            this.set("cn", this.getEn());
        }
        if (xx.isEmpty(defaulter = this.getStr("defaulter"))) {
            this.set("defaulter", "");
        } else if (defaulter.indexOf("(") != -1 && defaulter.indexOf(")") != -1) {
            this.set("defaulter", "");
        }
        MetaEngine.build(this);
    }

    public static String getFormType(ColumnMeta col) {
        String t = col.dataTypeName.toLowerCase();
        int s = col.dataSize;
        if (t.contains(DATATYPE_TIME) || t.contains("date")) {
            return TYPE_TIME;
        }
        if (col.isAuto) {
            return TYPE_AUTO;
        }
        if (s > 50) {
            return TYPE_TEXTS;
        }
        if (s == 1 && (t.equals("tinyint") || t.equals("char"))) {
            return TYPE_BOOL;
        }
        return TYPE_TEXT;
    }

    public MetaFieldConfig getConfig() {
        String json = this.getStr("config");
        if (xx.isEmpty(json)) {
            return null;
        }
        return (MetaFieldConfig)JSON.parseObject((String)json, MetaFieldConfig.class);
    }

    public void setConfig(MetaFieldConfig config) {
        this.set("config", JSON.toJSONString((Object)config));
    }

    public String getEn() {
        return this.getStr("en");
    }

    public String getCn() {
        return this.getStr("cn");
    }

    public String getType() {
        return this.getStr("type");
    }

    public int getDataType() {
        return this.getInt("data_type");
    }

    public boolean isVirtual() {
        if (xx.isEmpty(this.getStr("table_name"))) {
            return false;
        }
        return this.getStr("table_name").equals("virtual");
    }

    public String getDataTypeName() {
        return this.getStr("data_type_name").toUpperCase();
    }

    public int getDataSize() {
        return this.getInt("data_size");
    }

    public int getDataDecimal() {
        return this.getInt("data_decimal");
    }

    public MetaField getTemplate() {
        MetaField mf = (MetaField)((Object)this.queryFisrtByCache("select * from eova_field where id = 1"));
        mf.remove("id");
        return mf;
    }

    public List<MetaField> queryByObjectCode(String objectCode) {
        return dao.queryByCache("select * from eova_field where object_code = ? order by order_num", objectCode);
    }

    public List<MetaField> queryGroupByObjectCode(String objectCode) {
        return dao.queryByCache("select * from eova_field where object_code = ? order by fieldnum, order_num", objectCode);
    }

    public MetaField getByObjectCodeAndEn(String objectCode, String en) {
        MetaField ei = (MetaField)((Object)dao.queryFisrtByCache("select * from eova_field where object_code = ? and en = ? order by order_num", objectCode, en));
        return ei;
    }

    public void deleteByObjectId(int objectId) {
        String sql = "delete from eova_field where object_code = (select code from eova_object where id = ?)";
        Db.use((String)"eova").update(sql, new Object[]{objectId});
    }

    public void deleteByObjectCode(String objectCode) {
        String sql = "delete from eova_field where object_code = ?";
        Db.use((String)"eova").update(sql, new Object[]{objectCode});
    }

    public List<MetaField> queryShowFieldByObjectCode(String objectCode) {
        return dao.queryByCache("select * from eova_field where object_code = ? and is_show = 1 order by order_num", objectCode);
    }

    public List<MetaField> queryPoCodeByObjectCode(String objectCode) {
        return dao.find("SELECT DISTINCT(po_code) from eova_field where object_code = ?", new Object[]{objectCode});
    }

    public List<MetaField> queryFields(String objectCode) {
        return dao.queryByObjectCode(objectCode);
    }

    public List<MetaField> queryFields(String objectCode, User user) {
        List<MetaField> mfs = dao.queryByObjectCode(objectCode);
        this.buildMetaField(objectCode, user, mfs);
        return mfs;
    }

    public List<MetaField> queryFieldsGroup(String objectCode, User user) {
        List<MetaField> mfs = dao.queryGroupByObjectCode(objectCode);
        this.buildMetaField(objectCode, user, mfs);
        return mfs;
    }

    private void buildMetaField(String objectCode, User user, List<MetaField> mfs) {
        for (MetaField f : mfs) {
            Map<String, Set<String>> authFields;
            String type;
            String en = f.getStr("en");
            if (xx.isEmpty(f.getStr("exp"))) {
                if (f.getType().equals(TYPE_FIND)) {
                    throw new RuntimeException(String.format("\u5143\u5bf9\u8c61[%s]\u4e2d\u7684\u5143\u5b57\u6bb5[%s]\u662f\u67e5\u627e\u6846\uff0c\u8be5\u5b57\u6bb5\u5fc5\u987b\u586b\u5199Eova\u8868\u8fbe\u5f0f\uff01", objectCode, f.getEn()));
                }
                if (f.getType().equals(TYPE_COMBO)) {
                    throw new RuntimeException(String.format("\u5143\u5bf9\u8c61[%s]\u4e2d\u7684\u5143\u5b57\u6bb5[%s]\u662f\u4e0b\u62c9\u6846\uff0c\u8be5\u5b57\u6bb5\u5fc5\u987b\u586b\u5199Eova\u8868\u8fbe\u5f0f\uff01", objectCode, f.getEn()));
                }
            }
            if ((type = f.getType()).equals(TYPE_BOOL)) {
                f.put("editor", "eovabool");
            } else if (type.equals(TYPE_COMBO)) {
                f.put("editor", "eovacombo");
            } else if (type.equals(TYPE_COMBO_TREE)) {
                f.put("editor", "eovacombotree");
            } else if (type.equals(TYPE_FIND)) {
                f.put("editor", "eovafind");
            } else if (type.equals(TYPE_TIME)) {
                f.put("editor", "eovatime");
            } else if (type.equals(TYPE_TEXTS)) {
                f.put("editor", "eovainfo");
            } else {
                f.put("editor", "eovatext");
            }
            String defaulter = f.getStr("defaulter");
            if (!xx.isEmpty(defaulter)) {
                if (defaulter.equals("NOW") || defaulter.equals("CURRENT_TIMESTAMP")) {
                    f.set("defaulter", TimestampUtil.getNow());
                } else if (defaulter.equals("UUID")) {
                    f.set("defaulter", UUID.randomUUID().toString().replaceAll("-", "").toUpperCase());
                } else {
                    f.set("defaulter", DynamicParse.buildSql(f.getStr("defaulter"), new Object[]{user}));
                }
            }
            if (xx.isEmpty(authFields = EovaConfig.getAuthFields()) || user == null) continue;
            Integer rid = user.getInt("rid");
            String field = objectCode + "." + en;
            Set<String> set = authFields.get(field);
            if (xx.isEmpty(set) || set.contains(rid.toString())) continue;
            f.set("is_query", false);
            f.set("is_show", false);
            f.set("add_status", 50);
            f.set("update_status", 50);
        }
    }

    public int updateTableNameByCode(String objectCode, String en, String tableName) {
        return Db.use((String)"eova").update("update eova_field set table_name = ? where object_code = ? and en = ?", new Object[]{tableName, objectCode, en});
    }

    public void swapOrderNum(int sid, int tid, int snum, int tnum) {
        Db.use((String)"eova").update("update eova_field set order_num = ? where id = ?", new Object[]{tnum, sid});
        Db.use((String)"eova").update("update eova_field set order_num = ? where id = ?", new Object[]{snum, tid});
    }

    public void updateOrderNum(int sid, int snum) {
        Db.use((String)"eova").update("update eova_field set order_num = ? where id = ?", new Object[]{snum, sid});
    }
}

