/*
 * Decompiled with CFR 0.152.
 */
package com.eova.widget;

import com.eova.aop.AopContext;
import com.eova.aop.MetaObjectIntercept;
import com.eova.common.utils.xx;
import com.eova.core.menu.config.TreeConfig;
import com.eova.core.meta.MetaDataType;
import com.eova.core.object.config.MetaObjectConfig;
import com.eova.core.object.config.TableConfig;
import com.eova.engine.DynamicParse;
import com.eova.engine.EovaExp;
import com.eova.model.Menu;
import com.eova.model.MetaField;
import com.eova.model.MetaObject;
import com.eova.template.common.util.TemplateUtil;
import com.jfinal.core.Controller;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WidgetManager {
    public static String buildQuery(Controller ctrl, MetaObject object, Menu menu, MetaObjectIntercept intercept, List<Object> parmList) throws Exception {
        String menuFilter;
        String sql = "";
        String filter = object.getStr("filter");
        if (menu != null && !xx.isEmpty(menuFilter = menu.getStr("filter"))) {
            filter = menuFilter;
        }
        String where = WidgetManager.getWhere(ctrl, object.getFields(), parmList, filter);
        String sort = WidgetManager.getSort(ctrl, object.getStr("default_order"));
        String view = object.getView();
        sql = "from " + view;
        if (intercept != null) {
            AopContext ac = new AopContext(ctrl);
            intercept.queryBefore(ac);
            if (!xx.isEmpty(ac.sql)) {
                sql = "from " + String.format("(%s) AS T", ac.sql);
                where = "";
                sort = "";
                parmList.clear();
            } else {
                if (!xx.isEmpty(ac.condition)) {
                    where = where + ac.condition;
                    if (!xx.isEmpty(ac.params)) {
                        parmList.addAll(ac.params);
                    }
                }
                if (!xx.isEmpty(ac.where)) {
                    where = ac.where;
                    parmList.clear();
                    if (!xx.isEmpty(ac.params)) {
                        parmList.addAll(ac.params);
                    }
                }
                if (!xx.isEmpty(ac.sort)) {
                    sort = ac.sort;
                }
            }
        }
        sql = sql + String.format(" %s %s ", where, sort);
        return sql;
    }

    public static String getSort(Controller c, String order) {
        String sql = "";
        if (!xx.isEmpty(order)) {
            if (!order.toLowerCase().contains("order by")) {
                sql = sql + " order by ";
            }
            sql = sql + order;
        }
        String orderField = c.getPara("sort", "");
        String orderType = c.getPara("order", "");
        if (!xx.isEmpty(orderField)) {
            sql = " order by " + orderField + ' ' + orderType;
        }
        return sql;
    }

    public static String getSort(Controller c) {
        return WidgetManager.getSort(c, null);
    }

    public static String getWhere(Controller c, List<MetaField> eis, List<Object> parmList, String where) {
        where = DynamicParse.buildSql(where, c.getSessionAttr("user"));
        StringBuilder sb = new StringBuilder();
        boolean isWhere = true;
        for (MetaField ei : eis) {
            if (isWhere) {
                if (!xx.isEmpty(where)) {
                    if (!where.toString().toLowerCase().trim().startsWith("where")) {
                        sb.insert(0, " where ");
                    } else {
                        sb.append(" ");
                    }
                    sb.append(where + " ");
                } else {
                    sb.append(" where 1=1 ");
                }
                isWhere = false;
            }
            if (ei.isVirtual()) continue;
            String key = ei.getEn();
            String value = c.getPara("query_" + key, "").trim();
            String start = c.getPara("start_" + key, "").trim();
            String end = c.getPara("end_" + key, "").trim();
            if ((xx.isEmpty(value) || value.equals("-1")) && xx.isAllEmpty(start, end)) continue;
            if (xx.isEmpty(start)) {
                start = end;
            }
            if (xx.isEmpty(end)) {
                end = start;
            }
            value = TemplateUtil.convertValue(ei, value).toString();
            String type = ei.getStr("type");
            if (ei.getDataTypeName().toLowerCase().contains("int") && !xx.isEmpty(value)) {
                sb.append(" and " + key + " = ?");
                parmList.add(value);
            } else if (type.equals("\u6587\u672c\u6846") || type.equals("\u6587\u672c\u57df") || type.equals("\u7f16\u8f91\u6846")) {
                sb.append(" and " + key + " like ?");
                parmList.add("%" + value + "%");
            } else if (type.equals("\u6570\u5b57\u6846")) {
                String condition = c.getPara("condition_" + key, "").trim();
                if (condition.equals("=")) {
                    sb.append(" and ? = " + key);
                    parmList.add(start);
                } else if (condition.equals("<")) {
                    sb.append(" and ? > " + key);
                    parmList.add(start);
                } else if (condition.equals(">")) {
                    sb.append(" and ? < " + key);
                    parmList.add(start);
                } else {
                    if (xx.isOneEmpty(start, end)) continue;
                    if (condition.equals("\u2229")) {
                        sb.append(" and ? < " + key + " and " + key + " < ?");
                        parmList.add(start);
                        parmList.add(end);
                    } else if (condition.equals("U")) {
                        sb.append(" and ? > " + key + " or " + key + " < ?");
                        parmList.add(start);
                        parmList.add(end);
                    }
                }
            } else if (type.equals("\u65f6\u95f4\u6846") || type.equals("\u65e5\u671f\u6846")) {
                if (xx.isOneEmpty(start, end)) continue;
                if (xx.isOracle()) {
                    sb.append(" and " + key + " >= to_date(?,'yyyy-mm-dd') and " + key + " < to_date(?,'yyyy-mm-dd')+1");
                } else {
                    sb.append(" and date(" + key + ") >= ? and date(" + key + ") <= ?");
                }
                parmList.add(start);
                parmList.add(end);
            } else if (ei.getBoolean("is_multiple").booleanValue()) {
                sb.append(" and (");
                for (String val : value.split(",")) {
                    if (!sb.toString().endsWith(" (")) {
                        sb.append(" or ");
                    }
                    if (xx.isMysql()) {
                        sb.append(String.format("FIND_IN_SET(?, %s)", key));
                        parmList.add(val);
                        continue;
                    }
                    if (xx.isOracle()) {
                        sb.append(String.format("instr(','||%s||',' ,  ',%s,') > 0", key, val));
                        continue;
                    }
                    sb.append(key + " like ").append("?");
                    parmList.add('%' + val + '%');
                }
                sb.append(")");
            } else {
                sb.append(" and " + key + " = ?");
                parmList.add(value);
            }
            ei.put("value", value);
        }
        return sb.toString();
    }

    public static void buildWhere(StringBuilder sql) {
        if (!sql.toString().toLowerCase().contains("where")) {
            sql.append(" where 1=1 ");
        }
    }

    public static String addWhere(EovaExp se, String condition) {
        String select = se.simpleSelect;
        String from = se.from;
        String where = se.where;
        where = xx.isEmpty(where) ? " where " + condition : where + " and " + condition;
        return select + from + where;
    }

    public static void convertValueByExp(Controller c, List<MetaField> eis, List<Record> reList, String ... excludeFields) {
        block0: for (MetaField ei : eis) {
            String exp;
            String en = ei.getEn();
            if (!xx.isEmpty(excludeFields)) {
                for (String field : excludeFields) {
                    if (field.equals(en)) continue block0;
                }
            }
            if (!ei.getBoolean("is_show").booleanValue() || xx.isEmpty(exp = ei.getStr("exp"))) continue;
            HashSet<String> ids = new HashSet<String>();
            if (!xx.isEmpty(reList)) {
                for (Record re : reList) {
                    String value = re.get(en, (Object)"").toString();
                    if (value.contains(",")) {
                        for (String val : value.split(",")) {
                            ids.add(val);
                        }
                        continue;
                    }
                    ids.add(value);
                }
            }
            exp = DynamicParse.buildSql(exp, c.getSessionAttr("user"));
            EovaExp se = new EovaExp(exp);
            String select = se.simpleSelect;
            String where = se.where;
            String from = se.from;
            String pk = se.pk;
            String cn = se.cn;
            where = WidgetManager.filterValueCondition(where, pk);
            StringBuilder sql = new StringBuilder();
            sql.append(select);
            sql.append(from);
            sql.append(where);
            WidgetManager.buildWhere(sql);
            if (!xx.isEmpty(ids)) {
                sql.append(" and ").append(pk);
                sql.append(" in(");
                for (String id : ids) {
                    sql.append(xx.format(id)).append(",");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
            }
            List translates = Db.use((String)se.ds).find(sql.toString());
            for (Record re : reList) {
                Object o = re.get(en);
                if (o == null) {
                    re.set(en, (Object)"");
                    continue;
                }
                String value = o.toString();
                String text = "";
                if (value.contains(",")) {
                    for (String val : value.split(",")) {
                        text = text + WidgetManager.translateValue(pk, cn, translates, val);
                        text = text + ',';
                    }
                    text = xx.delEnd(text, ",");
                } else {
                    text = WidgetManager.translateValue(pk, cn, translates, value);
                }
                re.set(en, (Object)text);
            }
        }
    }

    public static String translateValue(String pk, String cn, List<Record> translates, String value) {
        for (Record r : translates) {
            String key = r.get(pk).toString();
            String name = r.get(cn).toString();
            if (!value.equals(key)) continue;
            return name;
        }
        return value;
    }

    public static Map<String, Record> buildData(Controller c, MetaObject object, Record record, String pkName, boolean isInsert) {
        HashMap<String, Record> datas = new HashMap<String, Record>();
        for (MetaField item : object.getFields()) {
            String type = item.getStr("type");
            String key = item.getEn();
            Object value = c.getPara(key);
            value = TemplateUtil.convertValue(item, value);
            if ((value = MetaDataType.convert(item, value)) == null && type.equals("\u81ea\u589e\u6846") || value == null) continue;
            record.set(key, value);
        }
        return datas;
    }

    @Deprecated
    public static void operateView(String mode, MetaObject object, Record data) {
        MetaObjectConfig config = object.getConfig();
        LinkedHashMap<String, TableConfig> view = config.getView();
        for (Map.Entry<String, TableConfig> entry : view.entrySet()) {
            String tableName = entry.getKey();
            TableConfig tc = entry.getValue();
            String whereField = tc.getWhereField();
            String paramField = tc.getParamField();
            Record po = WidgetManager.getRecordByTableName(object, data, tableName);
            if (po == null) continue;
            if (!po.getColumns().containsKey(whereField)) {
                po.set(whereField, data.get(paramField));
            }
            if (mode.equals("update")) {
                Db.use((String)object.getDs()).update(tableName, whereField, po);
                continue;
            }
            if (!mode.equals("add")) continue;
            Db.use((String)object.getDs()).save(tableName, po);
        }
    }

    private static Record getRecordByTableName(MetaObject object, Record data, String tableName) {
        List<MetaField> fields = object.getFields();
        Record r = null;
        for (MetaField f : fields) {
            String en;
            Object val;
            if (!tableName.equals(f.getStr("table_name")) || (val = data.get(en = f.getEn())) == null) continue;
            if (r == null) {
                r = new Record();
            }
            r.set(en, val);
        }
        return r;
    }

    public static String filterValueCondition(String where, String colName) {
        if (where.contains(colName)) {
            where = where.replaceAll("( " + colName + ".*?)and", "");
        }
        return where;
    }

    public static Record getRef(Controller c) {
        Record r = new Record();
        try {
            String[] fields;
            String ref = c.getPara("ref");
            if (xx.isEmpty(ref)) {
                return r;
            }
            for (String field : fields = ref.split(",")) {
                String[] strs = field.split(":");
                r.set(strs[0], (Object)strs[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return r;
        }
        return r;
    }

    public static void buildRef(Controller ctrl, MetaObject object) {
        for (MetaField ei : object.getFields()) {
            String key = ei.getEn();
            Record ref = WidgetManager.getRef(ctrl);
            if (ref == null || xx.isEmpty(ref.get(key))) continue;
            ei.put("value", ref.get(key));
            ei.put("is_disable", true);
        }
    }

    public static void main(String[] args) {
        String where = "where type = 3 and uid = ${user.id} and state = 3 and uid = 3 and uid in (1,2,3)";
        String pk = "uid";
        System.out.println(where);
        where = WidgetManager.filterValueCondition(where, pk);
        System.out.println(where);
        System.out.println(WidgetManager.addWhere(new EovaExp("select * from users where 1=1"), "id = 1"));
        System.out.println(WidgetManager.addWhere(new EovaExp("select id ID,name CN from users where a = 1"), "id = 1"));
    }

    public static void findParent(TreeConfig treeConfig, String ds, String select, String view, List<Record> list, List<Record> parents) {
        HashSet<String> pids = new HashSet<String>();
        for (Record x : parents) {
            pids.add(x.get(treeConfig.getParentField()).toString());
        }
        if (!xx.isEmpty(pids)) {
            if (pids.size() == 1 && pids.toArray()[0].equals(treeConfig.getRootPid())) {
                return;
            }
            parents = Db.use((String)ds).find(String.format("%s from %s where %s in (%s)", select, view, treeConfig.getIdField(), xx.join(pids, "'", ",")));
            for (Record p : parents) {
                boolean b = false;
                for (Record x : list) {
                    if (!x.get(treeConfig.getIdField()).toString().equals(p.get(treeConfig.getIdField()).toString())) continue;
                    b = true;
                    break;
                }
                if (b) continue;
                list.add(p);
            }
            WidgetManager.findParent(treeConfig, ds, select, view, list, parents);
        }
    }
}

