/*
 * Decompiled with CFR 0.152.
 */
package com.eova.widget.grid;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.eova.aop.AopContext;
import com.eova.aop.MetaObjectIntercept;
import com.eova.common.Easy;
import com.eova.common.render.XlsRender;
import com.eova.common.utils.db.DbUtil;
import com.eova.common.utils.xx;
import com.eova.core.meta.MetaDataType;
import com.eova.model.EovaLog;
import com.eova.model.Menu;
import com.eova.model.MetaField;
import com.eova.model.MetaObject;
import com.eova.service.sm;
import com.eova.template.common.util.TemplateUtil;
import com.eova.widget.WidgetManager;
import com.eova.widget.WidgetUtil;
import com.jfinal.core.Controller;
import com.jfinal.kit.JsonKit;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GridController
extends Controller {
    final Controller ctrl = this;
    protected MetaObjectIntercept intercept = null;
    private String errorInfo = "";

    public void export() throws Exception {
        String objectCode = this.getPara(0);
        String menuCode = this.getPara(1);
        MetaObject object = sm.meta.getMeta(objectCode);
        Menu menu = Menu.dao.findByCode(menuCode);
        this.intercept = (MetaObjectIntercept)TemplateUtil.initIntercept(object.getBizIntercept());
        ArrayList<Object> parmList = new ArrayList<Object>();
        String sql = WidgetManager.buildQuery(this.ctrl, object, menu, this.intercept, parmList);
        Object[] paras = new Object[parmList.size()];
        parmList.toArray(paras);
        List data = Db.use((String)object.getDs()).find("select *" + DbUtil.formatSql(sql), paras);
        if (this.intercept != null) {
            AopContext ac = new AopContext(this.ctrl, data);
            this.intercept.queryAfter(ac);
        }
        List<MetaField> fields = object.getFields();
        WidgetManager.convertValueByExp(this, fields, data, new String[0]);
        Iterator<MetaField> it = fields.iterator();
        while (it.hasNext()) {
            MetaField f = it.next();
            if (f.getBoolean("is_show").booleanValue()) continue;
            it.remove();
        }
        this.render(new XlsRender(data, fields, object));
    }

    public void query() throws Exception {
        String objectCode = this.getPara(0);
        String menuCode = this.getPara(1);
        int pageNumber = this.getParaToInt("page", 1);
        int pageSize = this.getParaToInt("rows", 100000);
        MetaObject object = sm.meta.getMeta(objectCode);
        Menu menu = Menu.dao.findByCode(menuCode);
        this.intercept = (MetaObjectIntercept)TemplateUtil.initIntercept(object.getBizIntercept());
        ArrayList<Object> parmList = new ArrayList<Object>();
        String sql = WidgetManager.buildQuery(this.ctrl, object, menu, this.intercept, parmList);
        Object[] paras = new Object[parmList.size()];
        parmList.toArray(paras);
        Page page = Db.use((String)object.getDs()).paginate(pageNumber, pageSize, "select *", DbUtil.formatSql(sql), paras);
        if (this.intercept != null) {
            AopContext ac = new AopContext(this.ctrl, page.getList());
            this.intercept.queryAfter(ac);
        }
        WidgetUtil.copyValueColumn(page.getList(), object.getPk(), object.getFields());
        WidgetManager.convertValueByExp(this, object.getFields(), page.getList(), new String[0]);
        String json = JsonKit.toJson((Object)page.getList());
        json = "{\"total\":" + page.getTotalRow() + ",\"rows\":" + json;
        json = json + "}";
        this.renderJson(json);
    }

    public void add() throws Exception {
        String objectCode = this.getPara(0);
        final MetaObject object = sm.meta.getMeta(objectCode);
        String json = this.getPara("rows");
        final List<Record> records = GridController.getRecordsByJson(json, object.getFields(), object.getPk());
        this.intercept = (MetaObjectIntercept)TemplateUtil.initIntercept(object.getBizIntercept());
        boolean flag = Db.use((String)object.getDs()).tx(new IAtom(){

            public boolean run() throws SQLException {
                try {
                    for (Record record : records) {
                        String msg;
                        AopContext ac = new AopContext(GridController.this.ctrl, record);
                        if (GridController.this.intercept != null && !xx.isEmpty(msg = GridController.this.intercept.addBefore(ac))) {
                            GridController.this.errorInfo = msg;
                            return false;
                        }
                        if (xx.isEmpty(object.getTable())) {
                            throw new Exception("\u89c6\u56fe\u6682\u65f6\u4e0d\u652f\u6301Grid \u5355\u5143\u683c\u7f16\u8f91\uff0c\u8bf7\u4f7f\u7528Form\u6a21\u5f0f\uff01");
                        }
                        Db.use((String)object.getDs()).save(object.getTable(), object.getPk(), record);
                        EovaLog.dao.info(GridController.this.ctrl, 1, object.getStr("code"));
                        if (GridController.this.intercept == null || xx.isEmpty(msg = GridController.this.intercept.addAfter(ac))) continue;
                        GridController.this.errorInfo = msg;
                        return false;
                    }
                }
                catch (Exception e) {
                    GridController.this.errorInfo = TemplateUtil.buildException(e);
                    return false;
                }
                return true;
            }
        });
        if (!flag) {
            this.renderJson(new Easy(this.errorInfo));
            return;
        }
        if (!flag) {
            this.renderJson(new Easy("\u65b0\u589e\u5931\u8d25" + this.errorInfo));
            return;
        }
        if (this.intercept != null) {
            try {
                AopContext ac = new AopContext((Controller)this, records);
                String msg = this.intercept.addSucceed(ac);
                if (!xx.isEmpty(msg)) {
                    this.errorInfo = msg;
                }
            }
            catch (Exception e) {
                this.errorInfo = TemplateUtil.buildException(e);
                this.renderJson(new Easy("\u65b0\u589e\u6210\u529f,addSucceed\u62e6\u622a\u6267\u884c\u5f02\u5e38!" + this.errorInfo));
                return;
            }
        }
        this.renderJson(new Easy());
    }

    public void delete() throws Exception {
        this.deleteOrHide(true);
    }

    public void hide() throws Exception {
        this.deleteOrHide(false);
    }

    private void deleteOrHide(final boolean isDel) throws Exception {
        String objectCode = this.getPara(0);
        final MetaObject object = sm.meta.getMeta(objectCode);
        String json = this.getPara("rows");
        final List<Record> records = GridController.getRecordsByJson(json, object.getFields(), object.getPk());
        this.intercept = (MetaObjectIntercept)TemplateUtil.initIntercept(object.getBizIntercept());
        boolean flag = Db.use((String)object.getDs()).tx(new IAtom(){

            public boolean run() throws SQLException {
                try {
                    for (Record record : records) {
                        String msg;
                        AopContext ac = new AopContext(GridController.this.ctrl, record);
                        if (GridController.this.intercept != null && isDel && !xx.isEmpty(msg = GridController.this.intercept.deleteBefore(ac))) {
                            GridController.this.errorInfo = msg;
                            return false;
                        }
                        if (!xx.isEmpty(object.getTable())) {
                            String pk = object.getPk();
                            String pkValue = record.get(pk).toString();
                            if (isDel) {
                                Db.use((String)object.getDs()).delete(object.getTable(), pk, record);
                            } else {
                                String hideFieldName = xx.getConfig("hide_field_name", "is_hide");
                                String sql = String.format("update %s set %s = 1 where %s = ?", object.getTable(), hideFieldName, pk);
                                Db.use((String)object.getDs()).update(sql, new Object[]{record.get(pk)});
                            }
                            EovaLog.dao.info(GridController.this.ctrl, 3, object.getStr("code") + "[" + pkValue + "]");
                        }
                        if (GridController.this.intercept == null || !isDel || xx.isEmpty(msg = GridController.this.intercept.deleteAfter(ac))) continue;
                        GridController.this.errorInfo = msg;
                        return false;
                    }
                }
                catch (Exception e) {
                    GridController.this.errorInfo = "\u5220\u9664\u5f02\u5e38:" + TemplateUtil.buildException(e);
                    return false;
                }
                return true;
            }
        });
        if (!flag) {
            this.renderJson(new Easy(this.errorInfo));
            return;
        }
        if (this.intercept != null && isDel) {
            try {
                AopContext ac = new AopContext((Controller)this, records);
                String msg = this.intercept.deleteSucceed(ac);
                if (!xx.isEmpty(msg)) {
                    this.errorInfo = msg;
                }
            }
            catch (Exception e) {
                this.errorInfo = TemplateUtil.buildException(e);
                this.renderJson(new Easy("\u5220\u9664\u6210\u529f,deleteSucceed\u6267\u884c\u5f02\u5e38!" + this.errorInfo));
                return;
            }
        }
        if (!xx.isEmpty(this.errorInfo)) {
            this.renderJson(new Easy(this.errorInfo));
            return;
        }
        this.renderJson(new Easy());
    }

    public void update() throws Exception {
        String objectCode = this.getPara(0);
        final MetaObject object = sm.meta.getMeta(objectCode);
        String json = this.getPara("rows");
        final List<Record> records = GridController.getRecordsByJson(json, object.getFields(), object.getPk());
        this.intercept = (MetaObjectIntercept)TemplateUtil.initIntercept(object.getBizIntercept());
        boolean flag = Db.use((String)object.getDs()).tx(new IAtom(){

            public boolean run() throws SQLException {
                try {
                    for (Record record : records) {
                        String msg;
                        AopContext ac = new AopContext(GridController.this.ctrl, record);
                        if (GridController.this.intercept != null && !xx.isEmpty(msg = GridController.this.intercept.updateBefore(ac))) {
                            GridController.this.errorInfo = msg;
                            return false;
                        }
                        if (xx.isEmpty(object.getTable())) {
                            throw new Exception("\u89c6\u56fe\u6682\u65f6\u4e0d\u652f\u6301Grid\u5355\u5143\u683c\u7f16\u8f91\uff0c\u8bf7\u4f7f\u7528Form\u6a21\u5f0f\uff01");
                        }
                        Db.use((String)object.getDs()).update(object.getTable(), object.getPk(), record);
                        EovaLog.dao.info(GridController.this.ctrl, 2, object.getStr("code") + "[" + record.get(object.getPk()) + "]");
                        if (GridController.this.intercept == null || xx.isEmpty(msg = GridController.this.intercept.updateAfter(ac))) continue;
                        GridController.this.errorInfo = msg;
                        return false;
                    }
                }
                catch (Exception e) {
                    GridController.this.errorInfo = TemplateUtil.buildException(e);
                    return false;
                }
                return true;
            }
        });
        if (!flag) {
            this.renderJson(new Easy(this.errorInfo));
            return;
        }
        if (!flag) {
            this.renderJson(new Easy("\u4fee\u6539\u5931\u8d25" + this.errorInfo));
            return;
        }
        if (this.intercept != null) {
            try {
                AopContext ac = new AopContext((Controller)this, records);
                String msg = this.intercept.updateSucceed(ac);
                if (!xx.isEmpty(msg)) {
                    this.errorInfo = msg;
                }
            }
            catch (Exception e) {
                this.errorInfo = TemplateUtil.buildException(e);
                this.renderJson(new Easy("\u4fee\u6539\u6210\u529f,updateSucceed\u62e6\u622a\u6267\u884c\u5f02\u5e38!" + this.errorInfo));
                return;
            }
        }
        this.renderJson(new Easy());
    }

    public void updateWidths() throws Exception {
        String objectCode = this.getPara(0);
        String widths = this.getPara(1);
        String[] ss = widths.split(",");
        int i = 0;
        List<MetaField> fields = MetaField.dao.queryShowFieldByObjectCode(objectCode);
        for (MetaField x : fields) {
            x.set("width", ss[i]);
            x.update();
            ++i;
        }
        this.renderJson(Easy.sucess());
    }

    private static List<Record> getRecordsByJson(String json, List<MetaField> items, String pkName) {
        ArrayList<Record> records = new ArrayList<Record>();
        List list = JSON.parseArray((String)json, JSONObject.class);
        for (JSONObject o : list) {
            Map map = (Map)JSON.parseObject((String)(o + ""), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            Record re = new Record();
            re.setColumns(map);
            for (MetaField x : items) {
                String en = x.getEn();
                String exp = x.getStr("exp");
                Object value = re.get(en);
                if (!xx.isEmpty(exp)) {
                    String valField = en + "_val";
                    value = re.get(valField);
                    re.remove(valField);
                }
                re.set(en, MetaDataType.convert(x, value));
            }
            re.remove("pk_val");
            if (xx.isOracle()) {
                re.remove("rownum_");
            }
            records.add(re);
        }
        return records;
    }

    public static void main(String[] args) {
        String sl = "[{'id':1,'loginId':'111'},{'id':2,'loginId':'222'}]";
        List list = JSON.parseArray((String)sl, JSONObject.class);
        for (JSONObject o : list) {
            Map map = (Map)JSON.parseObject((String)(o + ""), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            Record re = new Record();
            re.setColumns(map);
            System.out.println(re.toJson());
        }
    }
}

