/*
 * Decompiled with CFR 0.152.
 */
package com.eova.widget.tree;

import com.eova.common.utils.xx;
import com.eova.core.menu.config.TreeConfig;
import com.eova.widget.WidgetUtil;
import com.jfinal.kit.JsonKit;
import com.jfinal.plugin.activerecord.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TreeUtil {
    public static String toTreeJson(List<Record> list, TreeConfig treeConfig) {
        Map<String, Record> map = WidgetUtil.listToLinkedMap(list, treeConfig);
        return TreeUtil.map2TreeJson(map, treeConfig);
    }

    public static String map2TreeJson(Map<String, Record> temp, TreeConfig treeConfig) {
        String rootPid = treeConfig.getRootPid();
        String iconField = treeConfig.getIconField();
        String parentField = treeConfig.getParentField();
        for (Map.Entry<String, Record> map : temp.entrySet()) {
            Record x = map.getValue();
            String state = "open";
            Boolean isOpen = x.getBoolean("open");
            if (!xx.isEmpty(isOpen) && !isOpen.booleanValue()) {
                state = "closed";
            }
            x.set("state", (Object)state);
            x.set("iconCls", (Object)x.getStr(iconField));
            x.remove("open");
            x.remove(iconField);
        }
        temp.put(rootPid, new Record());
        for (Map.Entry<String, Record> map : temp.entrySet()) {
            Record re;
            String pid;
            Record parent;
            if (map.getKey() == rootPid || (parent = temp.get(pid = (re = map.getValue()).get(parentField).toString())) == null) continue;
            ArrayList<Record> children = (ArrayList<Record>)parent.get("children");
            if (children == null) {
                children = new ArrayList<Record>();
                temp.get(pid).set("children", children);
            }
            children.add(re);
        }
        StringBuilder sb = new StringBuilder("[");
        List childList = (List)temp.get(rootPid).get("children");
        for (Record x : childList) {
            if (!xx.isEmpty(x.get("children"))) {
                // empty if block
            }
            sb.append(JsonKit.toJson((Object)x));
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        String json = sb.toString();
        json = json.replaceAll("iconcls", "iconCls");
        return json;
    }
}

