/*
 * Decompiled with CFR 0.152.
 */
package com.eova.widget.upload;

import com.eova.common.utils.io.FileUtil;
import com.eova.common.utils.io.ImageUtil;
import com.eova.common.utils.xx;
import com.eova.config.EovaConfig;
import com.jfinal.core.Controller;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.Ret;
import com.jfinal.upload.UploadFile;
import java.io.File;
import java.util.List;

public class UploadController
extends Controller {
    public void img() {
        String name = this.getPara("name");
        String fileDir = this.getPara("filedir");
        String fileName = this.getPara("filename");
        Ret r = this.upload("img", name, fileDir, fileName, 10);
        this.renderJson(r);
    }

    public void file() {
        String name = this.getPara("name");
        String fileDir = this.getPara("filedir");
        String fileName = this.getPara("filename");
        Ret rt = this.upload("file", name, fileDir, fileName, xx.getConfigInt("upload_size", 50));
        this.renderJson(rt);
    }

    public void temp() {
        String name = this.getPara("name");
        Ret rt = this.upload("file", name, xx.getConfig("eova_upload_temp", "/temp"), null, xx.getConfigInt("upload_size", 50));
        this.renderJson(rt);
    }

    public void editor() {
        String domain = EovaConfig.getProps().get("domain_img");
        String editorDir = EovaConfig.getProps().get("dir_editor");
        if (xx.isEmpty(domain)) {
            throw new RuntimeException("\u56fe\u7247\u4e0a\u4f20\u5f02\u5e38,\u8bf7\u5148\u914d\u7f6e\u56fe\u7247\u670d\u52a1\u57df\u540d!\u914d\u7f6e\u9879:domain.config domain_img=\u56fe\u7247\u670d\u52a1\u57df\u540d");
        }
        if (xx.isEmpty(editorDir)) {
            throw new RuntimeException("\u56fe\u7247\u4e0a\u4f20\u5f02\u5e38,\u8bf7\u5148\u914d\u7f6e\u56fe\u7247\u670d\u52a1\u76ee\u5f55!\u914d\u7f6e\u9879:domain.config dir_editor=\u56fe\u7247\u76ee\u5f55");
        }
        Ret rt = this.upload("img", null, editorDir, null, xx.getConfigInt("upload_size", 50));
        if (rt.isFail()) {
            this.renderText("error|" + rt.getStr((Object)"msg"));
            return;
        }
        this.renderText(String.format("%s/%s/%s", xx.delEnd(domain, "/"), xx.delStart(editorDir, "/"), rt.getStr((Object)"fileName")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ret upload(String uploadType, String name, String fileDir, String fileName, int maxM) {
        if (xx.isEmpty(fileDir)) {
            fileDir = "/temp";
        }
        UploadFile file = null;
        try {
            String path;
            List files;
            fileDir = FileUtil.formatPath(fileDir);
            if (name != null) {
                file = this.getFile(name, fileDir);
            } else {
                files = this.getFiles(fileDir);
                if (xx.isEmpty(files)) {
                    Ret ret = Ret.fail((Object)"msg", (Object)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6587\u4ef6");
                    return ret;
                }
                file = (UploadFile)files.get(0);
            }
            if (xx.isEmpty(file)) {
                files = Ret.fail((Object)"msg", (Object)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6587\u4ef6");
                return files;
            }
            if (FileUtil.checkFileSize(file.getFile(), maxM)) {
                files = Ret.fail((Object)"msg", (Object)String.format("\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7%sM", maxM));
                return files;
            }
            if (uploadType.equalsIgnoreCase("img") && !ImageUtil.isImage(file.getFile().getPath())) {
                files = Ret.fail((Object)"msg", (Object)"\u8be5\u6587\u4ef6\u4e0d\u662f\u6807\u51c6\u7684\u56fe\u7247\u6587\u4ef6\u683c\u5f0f\uff0c\u8bf7\u52ff\u624b\u5de5\u4fee\u6539\u6587\u4ef6\u683c\u5f0f");
                return files;
            }
            if (xx.isEmpty(fileName)) {
                fileName = file.getFileName();
                String suffix = FileUtil.getFileType(fileName);
                fileName = System.currentTimeMillis() + suffix;
            }
            if (FileUtil.isExists(path = file.getUploadPath() + File.separator + fileName)) {
                FileUtil.delete(path);
            }
            FileUtil.rename(file.getFile().getPath(), path);
            LogKit.info((String)(file.getFile().getPath() + " -> " + path));
        }
        catch (Exception e) {
            e.printStackTrace();
            Ret ret = Ret.fail((Object)"msg", (Object)"\u7cfb\u7edf\u5f02\u5e38\uff1a\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return ret;
        }
        finally {
            FileUtil.delete(file.getFile());
        }
        return Ret.ok((Object)"fileName", (Object)fileName);
    }
}

