/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.dialect;

import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.ds.DataSourceWrapper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DriverUtil {
    public static String identifyDriver(String nameContainsProductInfo) {
        return DialectFactory.identifyDriver(nameContainsProductInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String identifyDriver(DataSource ds) {
        String driver;
        if (ds instanceof DataSourceWrapper && StrUtil.isNotBlank(driver = ((DataSourceWrapper)ds).getDriver())) {
            return driver;
        }
        Connection conn = null;
        String driver2 = null;
        try {
            try {
                conn = ds.getConnection();
            }
            catch (SQLException e) {
                throw new DbRuntimeException("Get Connection error !", e);
            }
            catch (NullPointerException e) {
                throw new DbRuntimeException("Unexpected NullPointException, maybe [jdbcUrl] or [url] is empty!", e);
            }
            driver2 = DriverUtil.identifyDriver(conn);
        }
        catch (Throwable throwable) {
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(conn);
        return driver2;
    }

    public static String identifyDriver(Connection conn) throws DbRuntimeException {
        String driver = null;
        try {
            DatabaseMetaData meta = conn.getMetaData();
            driver = DriverUtil.identifyDriver(meta.getDatabaseProductName());
            if (StrUtil.isBlank(driver)) {
                driver = DriverUtil.identifyDriver(meta.getDriverName());
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException("Identify driver error!", e);
        }
        return driver;
    }
}

