/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.qrcode;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Image;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;

public class QrConfig {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    protected int width;
    protected int height;
    protected int foreColor = -16777216;
    protected int backColor = -1;
    protected Integer margin = 2;
    protected ErrorCorrectionLevel errorCorrection = ErrorCorrectionLevel.M;
    protected Charset charset = CharsetUtil.CHARSET_UTF_8;
    protected Image img;
    protected int ratio = 6;

    public static QrConfig create() {
        return new QrConfig();
    }

    public QrConfig() {
        this(300, 300);
    }

    public QrConfig(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public QrConfig setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public QrConfig setHeight(int height) {
        this.height = height;
        return this;
    }

    public int getForeColor() {
        return this.foreColor;
    }

    public QrConfig setForeColor(int foreColor) {
        this.foreColor = foreColor;
        return this;
    }

    public int getBackColor() {
        return this.backColor;
    }

    public QrConfig setBackColor(int backColor) {
        this.backColor = backColor;
        return this;
    }

    public Integer getMargin() {
        return this.margin;
    }

    public QrConfig setMargin(Integer margin) {
        this.margin = margin;
        return this;
    }

    public ErrorCorrectionLevel getErrorCorrection() {
        return this.errorCorrection;
    }

    public QrConfig setErrorCorrection(ErrorCorrectionLevel errorCorrection) {
        this.errorCorrection = errorCorrection;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public QrConfig setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Image getImg() {
        return this.img;
    }

    public QrConfig setImg(String imgPath) {
        return this.setImg(FileUtil.file(imgPath));
    }

    public QrConfig setImg(File imgFile) {
        return this.setImg(ImgUtil.read(imgFile));
    }

    public QrConfig setImg(Image img) {
        this.img = img;
        return this;
    }

    public int getRatio() {
        return this.ratio;
    }

    public QrConfig setRatio(int ratio) {
        this.ratio = ratio;
        return this;
    }

    public HashMap<EncodeHintType, Object> toHints() {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        if (null != this.charset) {
            hints.put(EncodeHintType.CHARACTER_SET, this.charset.toString().toLowerCase());
        }
        if (null != this.errorCorrection) {
            hints.put(EncodeHintType.ERROR_CORRECTION, this.errorCorrection);
        }
        if (null != this.margin) {
            hints.put(EncodeHintType.MARGIN, this.margin);
        }
        return hints;
    }
}

