/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.cache;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.net.VIPServerProxy;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.NetUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class UnitCache {
    private static Map<Long, Unit> userId2Unit = new ConcurrentHashMap<Long, Unit>();
    private static ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("VIPSERVER-CLIENT-UNIT-UPDATER");
            return thread;
        }
    });
    private static Map<Long, Future<?>> futureMap = new HashMap();

    public static String getUnit(long userId) {
        Unit unit = userId2Unit.get(userId);
        if (unit == null || !unit.updated()) {
            if (unit == null) {
                UnitCache.updateUnitNow(userId);
            } else if (!unit.updated()) {
                unit.setLastRefMillis(unit.getLastRefMillis() + 1500L);
            }
            unit = userId2Unit.get(userId);
        }
        UnitCache.scheduleUpdateIfAbsent(userId);
        if (unit == null) {
            return "";
        }
        return unit.getUnit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleUpdateIfAbsent(long userId) {
        if (futureMap.get(userId) != null) {
            return;
        }
        Map<Long, Future<?>> map = futureMap;
        synchronized (map) {
            if (futureMap.get(userId) != null) {
                return;
            }
            ScheduledFuture<?> future = executorService.schedule(new UpdateTask(userId), 1000L, TimeUnit.MILLISECONDS);
            futureMap.put(userId, future);
        }
    }

    private static void updateUnitNow(long userId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", String.valueOf(userId));
        params.put("clientIP", NetUtils.localIP());
        try {
            Unit unit;
            String result = VIPServerProxy.reqAPI("getUnitByUserId", params);
            System.out.println("update unit");
            if (!StringUtils.isEmpty(result) && (unit = JSON.parseObject(result, Unit.class)) != null && !StringUtils.isEmpty(unit.getUnit())) {
                userId2Unit.put(userId, unit);
            }
        }
        catch (Exception e) {
            VIPClient.LOG.warn("failed to update unit by userId: " + userId, e);
        }
    }

    private static class Unit {
        String unit;
        long cacheMillis = 1000L;
        long lastRefMillis = -1L;

        private Unit() {
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public long getCacheMillis() {
            return this.cacheMillis;
        }

        public void setCacheMillis(long cacheMillis) {
            this.cacheMillis = cacheMillis;
        }

        public long getLastRefMillis() {
            return this.lastRefMillis;
        }

        public void setLastRefMillis(long lastRefMillis) {
            this.lastRefMillis = lastRefMillis;
        }

        public boolean updated() {
            return System.currentTimeMillis() - this.lastRefMillis < this.cacheMillis;
        }
    }

    private static class UpdateTask
    implements Runnable {
        long userId;

        public UpdateTask(long userId) {
            this.userId = userId;
        }

        @Override
        public void run() {
            try {
                UnitCache.updateUnitNow(this.userId);
                long delay = userId2Unit.containsKey(this.userId) ? ((Unit)userId2Unit.get(this.userId)).getCacheMillis() : 1000L;
                executorService.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                VIPClient.LOG.warn("failed to update unit by userId: " + this.userId, e);
            }
            catch (Error error) {
                VIPClient.LOG.warn("failed to update unit by userId: " + this.userId, error);
            }
        }
    }
}

