/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.core;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.HostReactor;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.IOUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringEscapeUtils;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class PushRecver
implements Runnable {
    public static int UDP_MSS = 65536;
    private DatagramSocket udpSocket;
    private Thread pushRcev;

    public PushRecver() {
        try {
            this.udpSocket = new DatagramSocket();
            this.pushRcev = new Thread((Runnable)this, "com.alibaba.ans.shaded.com.taobao.vipserver.pushrecv");
            this.pushRcev.setDaemon(true);
            this.pushRcev.start();
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "init udp socket failed", e);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    String ack;
                    byte[] buffer = new byte[UDP_MSS];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.udpSocket.receive(packet);
                    String json = new String(IOUtils.tryDecompress(packet.getData()), "GBK").trim();
                    VIPClient.LOG.info("received push data: " + json + " from " + packet.getAddress().toString());
                    PushPacket pushPacket = JSON.parseObject(json, PushPacket.class);
                    if (pushPacket.type.equals("dom")) {
                        HostReactor.processDomJSON(pushPacket.data);
                        ack = "{\"type\": \"push-ack\", \"lastRefTime\":\"" + pushPacket.lastRefTime + "\", \"data\":\"\"}";
                    } else {
                        ack = pushPacket.type.equals("dump") ? "{\"type\": \"dump-ack\", \"lastRefTime\": \"" + pushPacket.lastRefTime + "\", \"data\":\"" + StringEscapeUtils.escapeJavaScript(JSON.toJSONString(HostReactor.getDomMap())) + "\"}" : "{\"type\": \"unknown-ack\", \"lastRefTime\":\"" + pushPacket.lastRefTime + "\", \"data\":\"\"}";
                    }
                    this.udpSocket.send(new DatagramPacket(ack.getBytes(), ack.getBytes().length, packet.getSocketAddress()));
                }
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "error while receiving push data", e);
                continue;
            }
            break;
        }
    }

    public int getUDPPort() {
        return this.udpSocket.getLocalPort();
    }

    public static class PushPacket {
        public String type;
        public long lastRefTime;
        public String data;
    }
}

